% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_attached_file_upload}
\alias{connect_start_attached_file_upload}
\title{Provides a pre-signed Amazon S3 URL in response for uploading your
content}
\usage{
connect_start_attached_file_upload(
  ClientToken = NULL,
  InstanceId,
  FileName,
  FileSizeInBytes,
  UrlExpiryInSeconds = NULL,
  FileUseCaseType,
  AssociatedResourceArn,
  CreatedBy = NULL,
  Tags = NULL
)
}
\arguments{
\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}

\item{InstanceId}{[required] The unique identifier of the Amazon Connect instance.}

\item{FileName}{[required] A case-sensitive name of the attached file being uploaded.}

\item{FileSizeInBytes}{[required] The size of the attached file in bytes.}

\item{UrlExpiryInSeconds}{Optional override for the expiry of the pre-signed S3 URL in seconds.
The default value is 300.}

\item{FileUseCaseType}{[required] The use case for the file.}

\item{AssociatedResourceArn}{[required] The resource to which the attached file is (being) uploaded to.
\href{https://docs.aws.amazon.com/connect/latest/APIReference/API_connect-cases_CreateCase.html}{Cases}
are the only current supported resource.

This value must be a valid ARN.}

\item{CreatedBy}{Represents the identity that created the file.}

\item{Tags}{The tags used to organize, track, or control access for this resource.
For example, \verb{\{ "Tags": \{"key1":"value1", "key2":"value2"\} \}}.}
}
\description{
Provides a pre-signed Amazon S3 URL in response for uploading your content.

See \url{https://www.paws-r-sdk.com/docs/connect_start_attached_file_upload/} for full documentation.
}
\keyword{internal}
