% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectparticipant_operations.R
\name{connectparticipant_start_attachment_upload}
\alias{connectparticipant_start_attachment_upload}
\title{Provides a pre-signed Amazon S3 URL in response for uploading the file
directly to S3}
\usage{
connectparticipant_start_attachment_upload(
  ContentType,
  AttachmentSizeInBytes,
  AttachmentName,
  ClientToken,
  ConnectionToken
)
}
\arguments{
\item{ContentType}{[required] Describes the MIME file type of the attachment. For a list of supported
file types, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/feature-limits.html}{Feature specifications}
in the \emph{Amazon Connect Administrator Guide}.}

\item{AttachmentSizeInBytes}{[required] The size of the attachment in bytes.}

\item{AttachmentName}{[required] A case-sensitive name of the attachment being uploaded.}

\item{ClientToken}{[required] A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}

\item{ConnectionToken}{[required] The authentication token associated with the participant's connection.}
}
\description{
Provides a pre-signed Amazon S3 URL in response for uploading the file directly to S3.

See \url{https://www.paws-r-sdk.com/docs/connectparticipant_start_attachment_upload/} for full documentation.
}
\keyword{internal}
