% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpointsmsvoicev2_operations.R
\name{pinpointsmsvoicev2_update_event_destination}
\alias{pinpointsmsvoicev2_update_event_destination}
\title{Updates an existing event destination in a configuration set}
\usage{
pinpointsmsvoicev2_update_event_destination(
  ConfigurationSetName,
  EventDestinationName,
  Enabled = NULL,
  MatchingEventTypes = NULL,
  CloudWatchLogsDestination = NULL,
  KinesisFirehoseDestination = NULL,
  SnsDestination = NULL
)
}
\arguments{
\item{ConfigurationSetName}{[required] The configuration set to update with the new event destination. Valid
values for this can be the ConfigurationSetName or ConfigurationSetArn.}

\item{EventDestinationName}{[required] The name to use for the event destination.}

\item{Enabled}{When set to true logging is enabled.}

\item{MatchingEventTypes}{An array of event types that determine which events to log.}

\item{CloudWatchLogsDestination}{An object that contains information about an event destination that
sends data to CloudWatch Logs.}

\item{KinesisFirehoseDestination}{An object that contains information about an event destination for
logging to Kinesis Data Firehose.}

\item{SnsDestination}{An object that contains information about an event destination that
sends data to Amazon SNS.}
}
\description{
Updates an existing event destination in a configuration set. You can update the IAM role ARN for CloudWatch Logs and Kinesis Data Firehose. You can also enable or disable the event destination.

See \url{https://paws-r.github.io/docs/pinpointsmsvoicev2/update_event_destination.html} for full documentation.
}
\keyword{internal}
