% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_send_bounce}
\alias{ses_send_bounce}
\title{Generates and sends a bounce message to the sender of an email you
received through Amazon SES}
\usage{
ses_send_bounce(OriginalMessageId, BounceSender, Explanation,
  MessageDsn, BouncedRecipientInfoList, BounceSenderArn)
}
\arguments{
\item{OriginalMessageId}{[required] The message ID of the message to be bounced.}

\item{BounceSender}{[required] The address to use in the "From" header of the bounce message. This
must be an identity that you have verified with Amazon SES.}

\item{Explanation}{Human-readable text for the bounce message to explain the failure. If
not specified, the text will be auto-generated based on the bounced
recipient information.}

\item{MessageDsn}{Message-related DSN fields. If not specified, Amazon SES will choose the
values.}

\item{BouncedRecipientInfoList}{[required] A list of recipients of the bounced message, including the information
required to create the Delivery Status Notifications (DSNs) for the
recipients. You must specify at least one \code{BouncedRecipientInfo} in the
list.}

\item{BounceSenderArn}{This parameter is used only for sending authorization. It is the ARN of
the identity that is associated with the sending authorization policy
that permits you to use the address in the "From" header of the
bounce. For more information about sending authorization, see the
\href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html}{Amazon SES Developer Guide}.}
}
\description{
Generates and sends a bounce message to the sender of an email you
received through Amazon SES. You can only use this API on an email up to
24 hours after you receive it.
}
\details{
You cannot use this API to send generic bounces for mail that was not
received by Amazon SES.

For information about receiving email through Amazon SES, see the
\href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email.html}{Amazon SES Developer Guide}.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$send_bounce(
  OriginalMessageId = "string",
  BounceSender = "string",
  Explanation = "string",
  MessageDsn = list(
    ReportingMta = "string",
    ArrivalDate = as.POSIXct(
      "2015-01-01"
    ),
    ExtensionFields = list(
      list(
        Name = "string",
        Value = "string"
      )
    )
  ),
  BouncedRecipientInfoList = list(
    list(
      Recipient = "string",
      RecipientArn = "string",
      BounceType = "DoesNotExist"|"MessageTooLarge"|"ExceededQuota"|"ContentRejected"|"Undefined"|"TemporaryFailure",
      RecipientDsnFields = list(
        FinalRecipient = "string",
        Action = "failed"|"delayed"|"delivered"|"relayed"|"expanded",
        RemoteMta = "string",
        Status = "string",
        DiagnosticCode = "string",
        LastAttemptDate = as.POSIXct(
          "2015-01-01"
        ),
        ExtensionFields = list(
          list(
            Name = "string",
            Value = "string"
          )
        )
      )
    )
  ),
  BounceSenderArn = "string"
)
}
}

\keyword{internal}
