% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_service.R
\name{pinpoint}
\alias{pinpoint}
\title{Amazon Pinpoint}
\usage{
pinpoint()
}
\description{
Doc Engage API - Amazon Pinpoint API
}
\section{Operations}{

\tabular{ll}{
\link[=pinpoint_create_app]{create_app} \tab Creates an application \cr
\link[=pinpoint_create_campaign]{create_campaign} \tab Creates a new campaign for an application or updates the settings of an existing campaign for an application \cr
\link[=pinpoint_create_export_job]{create_export_job} \tab Creates a new export job for an application \cr
\link[=pinpoint_create_import_job]{create_import_job} \tab Creates a new import job for an application \cr
\link[=pinpoint_create_segment]{create_segment} \tab Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application\cr
\link[=pinpoint_delete_adm_channel]{delete_adm_channel} \tab Disables the ADM channel for an application and deletes any existing settings for the channel \cr
\link[=pinpoint_delete_apns_channel]{delete_apns_channel} \tab Disables the APNs channel for an application and deletes any existing settings for the channel \cr
\link[=pinpoint_delete_apns_sandbox_channel]{delete_apns_sandbox_channel} \tab Disables the APNs sandbox channel for an application and deletes any existing settings for the channel \cr
\link[=pinpoint_delete_apns_voip_channel]{delete_apns_voip_channel} \tab Disables the APNs VoIP channel for an application and deletes any existing settings for the channel \cr
\link[=pinpoint_delete_apns_voip_sandbox_channel]{delete_apns_voip_sandbox_channel} \tab Disables the APNs VoIP sandbox channel for an application and deletes any existing settings for the channel \cr
\link[=pinpoint_delete_app]{delete_app} \tab Deletes an application \cr
\link[=pinpoint_delete_baidu_channel]{delete_baidu_channel} \tab Disables the Baidu channel for an application and deletes any existing settings for the channel \cr
\link[=pinpoint_delete_campaign]{delete_campaign} \tab Deletes a campaign from an application \cr
\link[=pinpoint_delete_email_channel]{delete_email_channel} \tab Disables the email channel for an application and deletes any existing settings for the channel \cr
\link[=pinpoint_delete_endpoint]{delete_endpoint} \tab Deletes an endpoint from an application \cr
\link[=pinpoint_delete_event_stream]{delete_event_stream} \tab Deletes the event stream for an application \cr
\link[=pinpoint_delete_gcm_channel]{delete_gcm_channel} \tab Disables the GCM channel for an application and deletes any existing settings for the channel \cr
\link[=pinpoint_delete_segment]{delete_segment} \tab Deletes a segment from an application \cr
\link[=pinpoint_delete_sms_channel]{delete_sms_channel} \tab Disables the SMS channel for an application and deletes any existing settings for the channel \cr
\link[=pinpoint_delete_user_endpoints]{delete_user_endpoints} \tab Deletes all the endpoints that are associated with a specific user ID \cr
\link[=pinpoint_delete_voice_channel]{delete_voice_channel} \tab Disables the voice channel for an application and deletes any existing settings for the channel \cr
\link[=pinpoint_get_adm_channel]{get_adm_channel} \tab Retrieves information about the status and settings of the ADM channel for an application \cr
\link[=pinpoint_get_apns_channel]{get_apns_channel} \tab Retrieves information about the status and settings of the APNs channel for an application \cr
\link[=pinpoint_get_apns_sandbox_channel]{get_apns_sandbox_channel} \tab Retrieves information about the status and settings of the APNs sandbox channel for an application \cr
\link[=pinpoint_get_apns_voip_channel]{get_apns_voip_channel} \tab Retrieves information about the status and settings of the APNs VoIP channel for an application \cr
\link[=pinpoint_get_apns_voip_sandbox_channel]{get_apns_voip_sandbox_channel} \tab Retrieves information about the status and settings of the APNs VoIP sandbox channel for an application \cr
\link[=pinpoint_get_app]{get_app} \tab Retrieves information about an application \cr
\link[=pinpoint_get_application_settings]{get_application_settings} \tab Retrieves information about the settings for an application \cr
\link[=pinpoint_get_apps]{get_apps} \tab Retrieves information about all of your applications \cr
\link[=pinpoint_get_baidu_channel]{get_baidu_channel} \tab Retrieves information about the status and settings of the Baidu Cloud Push channel for an application \cr
\link[=pinpoint_get_campaign]{get_campaign} \tab Retrieves information about the status, configuration, and other settings for a campaign \cr
\link[=pinpoint_get_campaign_activities]{get_campaign_activities} \tab Retrieves information about the activity performed by a campaign \cr
\link[=pinpoint_get_campaign_version]{get_campaign_version} \tab Retrieves information about the status, configuration, and other settings for a specific version of a campaign \cr
\link[=pinpoint_get_campaign_versions]{get_campaign_versions} \tab Retrieves information about the status, configuration, and other settings for all versions of a specific campaign \cr
\link[=pinpoint_get_campaigns]{get_campaigns} \tab Retrieves information about the status, configuration, and other settings for all the campaigns that are associated with an application \cr
\link[=pinpoint_get_channels]{get_channels} \tab Retrieves information about the history and status of each channel for an application \cr
\link[=pinpoint_get_email_channel]{get_email_channel} \tab Retrieves information about the status and settings of the email channel for an application \cr
\link[=pinpoint_get_endpoint]{get_endpoint} \tab Retrieves information about the settings and attributes of a specific endpoint for an application \cr
\link[=pinpoint_get_event_stream]{get_event_stream} \tab Retrieves information about the event stream settings for an application \cr
\link[=pinpoint_get_export_job]{get_export_job} \tab Retrieves information about the status and settings of a specific export job for an application \cr
\link[=pinpoint_get_export_jobs]{get_export_jobs} \tab Retrieves information about the status and settings of all the export jobs for an application \cr
\link[=pinpoint_get_gcm_channel]{get_gcm_channel} \tab Retrieves information about the status and settings of the GCM channel for an application \cr
\link[=pinpoint_get_import_job]{get_import_job} \tab Retrieves information about the status and settings of a specific import job for an application \cr
\link[=pinpoint_get_import_jobs]{get_import_jobs} \tab Retrieves information about the status and settings of all the import jobs for an application \cr
\link[=pinpoint_get_segment]{get_segment} \tab Retrieves information about the configuration, dimension, and other settings for a specific segment that's associated with an application \cr
\link[=pinpoint_get_segment_export_jobs]{get_segment_export_jobs} \tab Retrieves information about the status and settings of the export jobs for a segment \cr
\link[=pinpoint_get_segment_import_jobs]{get_segment_import_jobs} \tab Retrieves information about the status and settings of the import jobs for a segment \cr
\link[=pinpoint_get_segment_version]{get_segment_version} \tab Retrieves information about the configuration, dimension, and other settings for a specific version of a segment that's associated with an application \cr
\link[=pinpoint_get_segment_versions]{get_segment_versions} \tab Retrieves information about the configuration, dimension, and other settings for all versions of a specific segment that's associated with an application \cr
\link[=pinpoint_get_segments]{get_segments} \tab Retrieves information about the configuration, dimension, and other settings for all the segments that are associated with an application \cr
\link[=pinpoint_get_sms_channel]{get_sms_channel} \tab Retrieves information about the status and settings of the SMS channel for an application \cr
\link[=pinpoint_get_user_endpoints]{get_user_endpoints} \tab Retrieves information about all the endpoints that are associated with a specific user ID \cr
\link[=pinpoint_get_voice_channel]{get_voice_channel} \tab Retrieves information about the status and settings of the voice channel for an application \cr
\link[=pinpoint_list_tags_for_resource]{list_tags_for_resource} \tab Retrieves all the tags (keys and values) that are associated with an application, campaign, or segment \cr
\link[=pinpoint_phone_number_validate]{phone_number_validate} \tab Retrieves information about a phone number \cr
\link[=pinpoint_put_event_stream]{put_event_stream} \tab Creates a new event stream for an application or updates the settings of an existing event stream for an application \cr
\link[=pinpoint_put_events]{put_events} \tab Creates a new event to record for endpoints, or creates or updates endpoint data that existing events are associated with \cr
\link[=pinpoint_remove_attributes]{remove_attributes} \tab Removes one or more attributes, of the same attribute type, from all the endpoints that are associated with an application \cr
\link[=pinpoint_send_messages]{send_messages} \tab Creates and sends a direct message \cr
\link[=pinpoint_send_users_messages]{send_users_messages} \tab Creates and sends a message to a list of users \cr
\link[=pinpoint_tag_resource]{tag_resource} \tab Adds one or more tags (keys and values) to an application, campaign, or segment \cr
\link[=pinpoint_untag_resource]{untag_resource} \tab Removes one or more tags (keys and values) from an application, campaign, or segment \cr
\link[=pinpoint_update_adm_channel]{update_adm_channel} \tab Updates the ADM channel settings for an application \cr
\link[=pinpoint_update_apns_channel]{update_apns_channel} \tab Updates the APNs channel settings for an application \cr
\link[=pinpoint_update_apns_sandbox_channel]{update_apns_sandbox_channel} \tab Updates the APNs sandbox channel settings for an application \cr
\link[=pinpoint_update_apns_voip_channel]{update_apns_voip_channel} \tab Updates the APNs VoIP channel settings for an application \cr
\link[=pinpoint_update_apns_voip_sandbox_channel]{update_apns_voip_sandbox_channel} \tab Updates the settings for the APNs VoIP sandbox channel for an application \cr
\link[=pinpoint_update_application_settings]{update_application_settings} \tab Updates the settings for an application \cr
\link[=pinpoint_update_baidu_channel]{update_baidu_channel} \tab Updates the settings of the Baidu channel for an application \cr
\link[=pinpoint_update_campaign]{update_campaign} \tab Updates the settings for a campaign \cr
\link[=pinpoint_update_email_channel]{update_email_channel} \tab Updates the status and settings of the email channel for an application \cr
\link[=pinpoint_update_endpoint]{update_endpoint} \tab Creates a new endpoint for an application or updates the settings and attributes of an existing endpoint for an application \cr
\link[=pinpoint_update_endpoints_batch]{update_endpoints_batch} \tab Creates a new batch of endpoints for an application or updates the settings and attributes of a batch of existing endpoints for an application \cr
\link[=pinpoint_update_gcm_channel]{update_gcm_channel} \tab Updates the status and settings of the GCM channel for an application \cr
\link[=pinpoint_update_segment]{update_segment} \tab Creates a new segment for an application or updates the configuration, dimension, and other settings for an existing segment that's associated with an application\cr
\link[=pinpoint_update_sms_channel]{update_sms_channel} \tab Updates the status and settings of the SMS channel for an application \cr
\link[=pinpoint_update_voice_channel]{update_voice_channel} \tab Updates the status and settings of the voice channel for an application
}
}

\examples{
\donttest{svc <- pinpoint()
svc$create_app(
  Foo = 123
)}

}
