% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paymentcryptographydataplane_operations.R
\name{paymentcryptographydataplane_encrypt_data}
\alias{paymentcryptographydataplane_encrypt_data}
\title{Encrypts plaintext data to ciphertext using symmetric, asymmetric, or
DUKPT data encryption key}
\usage{
paymentcryptographydataplane_encrypt_data(
  EncryptionAttributes,
  KeyIdentifier,
  PlainText
)
}
\arguments{
\item{EncryptionAttributes}{[required] The encryption key type and attributes for plaintext encryption.}

\item{KeyIdentifier}{[required] The \code{keyARN} of the encryption key that Amazon Web Services Payment
Cryptography uses for plaintext encryption.}

\item{PlainText}{[required] The plaintext to be encrypted.}
}
\description{
Encrypts plaintext data to ciphertext using symmetric, asymmetric, or DUKPT data encryption key. For more information, see \href{https://docs.aws.amazon.com/payment-cryptography/latest/userguide/encrypt-data.html}{Encrypt data} in the \emph{Amazon Web Services Payment Cryptography User Guide}.

See \url{https://www.paws-r-sdk.com/docs/paymentcryptographydataplane_encrypt_data/} for full documentation.
}
\keyword{internal}
