% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billingconductor_operations.R
\name{billingconductor_create_billing_group}
\alias{billingconductor_create_billing_group}
\title{Creates a billing group that resembles a consolidated billing family
that Amazon Web Services charges, based off of the predefined pricing
plan computation}
\usage{
billingconductor_create_billing_group(
  ClientToken = NULL,
  Name,
  AccountGrouping,
  ComputationPreference,
  PrimaryAccountId = NULL,
  Description = NULL,
  Tags = NULL
)
}
\arguments{
\item{ClientToken}{The token that is needed to support idempotency. Idempotency isn't
currently supported, but will be implemented in a future update.}

\item{Name}{[required] The billing group name. The names must be unique.}

\item{AccountGrouping}{[required] The set of accounts that will be under the billing group. The set of
accounts resemble the linked accounts in a consolidated family.}

\item{ComputationPreference}{[required] The preferences and settings that will be used to compute the Amazon Web
Services charges for a billing group.}

\item{PrimaryAccountId}{The account ID that serves as the main account in a billing group.}

\item{Description}{The description of the billing group.}

\item{Tags}{A map that contains tag keys and tag values that are attached to a
billing group. This feature isn't available during the beta.}
}
\description{
Creates a billing group that resembles a consolidated billing family that Amazon Web Services charges, based off of the predefined pricing plan computation.

See \url{https://www.paws-r-sdk.com/docs/billingconductor_create_billing_group/} for full documentation.
}
\keyword{internal}
