% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplacemetering_operations.R
\name{marketplacemetering_register_usage}
\alias{marketplacemetering_register_usage}
\title{Paid container software products sold through AWS Marketplace must
integrate with the AWS Marketplace Metering Service and call the
RegisterUsage operation for software entitlement and metering}
\usage{
marketplacemetering_register_usage(ProductCode, PublicKeyVersion, Nonce)
}
\arguments{
\item{ProductCode}{[required] Product code is used to uniquely identify a product in AWS Marketplace.
The product code should be the same as the one used during the
publishing of a new product.}

\item{PublicKeyVersion}{[required] Public Key Version provided by AWS Marketplace}

\item{Nonce}{(Optional) To scope down the registration to a specific running software
instance and guard against replay attacks.}
}
\description{
Paid container software products sold through AWS Marketplace must
integrate with the AWS Marketplace Metering Service and call the
RegisterUsage operation for software entitlement and metering. Calling
RegisterUsage from containers running outside of ECS is not currently
supported. Free and BYOL products for ECS aren't required to call
RegisterUsage, but you may choose to do so if you would like to receive
usage data in your seller reports. The sections below explain the
behavior of RegisterUsage. RegisterUsage performs two primary functions:
metering and entitlement.
}
\details{
\itemize{
\item \emph{Entitlement}: RegisterUsage allows you to verify that the customer
running your paid software is subscribed to your product on AWS
Marketplace, enabling you to guard against unauthorized use. Your
container image that integrates with RegisterUsage is only required
to guard against unauthorized use at container startup, as such a
CustomerNotSubscribedException/PlatformNotSupportedException will
only be thrown on the initial call to RegisterUsage. Subsequent
calls from the same Amazon ECS task instance (e.g. task-id) will not
throw a CustomerNotSubscribedException, even if the customer
unsubscribes while the Amazon ECS task is still running.
\item \emph{Metering}: RegisterUsage meters software use per ECS task, per
hour, with usage prorated to the second. A minimum of 1 minute of
usage applies to tasks that are short lived. For example, if a
customer has a 10 node ECS cluster and creates an ECS service
configured as a Daemon Set, then ECS will launch a task on all 10
cluster nodes and the customer will be charged: (10 *
hourly\_rate). Metering for software use is automatically handled by
the AWS Marketplace Metering Control Plane \-- your software is not
required to perform any metering specific actions, other than call
RegisterUsage once for metering of software use to commence. The AWS
Marketplace Metering Control Plane will also continue to bill
customers for running ECS tasks, regardless of the customers
subscription state, removing the need for your software to perform
entitlement checks at runtime.
}
}
\section{Request syntax}{
\preformatted{svc$register_usage(
  ProductCode = "string",
  PublicKeyVersion = 123,
  Nonce = "string"
)
}
}

\keyword{internal}
