% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marketplacemetering_operations.R
\name{marketplacemetering_meter_usage}
\alias{marketplacemetering_meter_usage}
\title{API to emit metering records}
\usage{
marketplacemetering_meter_usage(ProductCode, Timestamp, UsageDimension,
  UsageQuantity, DryRun)
}
\arguments{
\item{ProductCode}{[required] Product code is used to uniquely identify a product in AWS Marketplace.
The product code should be the same as the one used during the
publishing of a new product.}

\item{Timestamp}{[required] Timestamp, in UTC, for which the usage is being reported. Your
application can meter usage for up to one hour in the past. Make sure
the timestamp value is not before the start of the software usage.}

\item{UsageDimension}{[required] It will be one of the fcp dimension name provided during the publishing
of the product.}

\item{UsageQuantity}{Consumption value for the hour. Defaults to \code{0} if not specified.}

\item{DryRun}{Checks whether you have the permissions required for the action, but
does not make the request. If you have the permissions, the request
returns DryRunOperation; otherwise, it returns UnauthorizedException.
Defaults to \code{false} if not specified.}
}
\description{
API to emit metering records. For identical requests, the API is
idempotent. It simply returns the metering record ID.
}
\details{
MeterUsage is authenticated on the buyer's AWS account, generally when
running from an EC2 instance on the AWS Marketplace.
}
\section{Request syntax}{
\preformatted{svc$meter_usage(
  ProductCode = "string",
  Timestamp = as.POSIXct(
    "2015-01-01"
  ),
  UsageDimension = "string",
  UsageQuantity = 123,
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
