# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' AWS Marketplace Commerce Analytics
#'
#' @description
#' Provides AWS Marketplace business intelligence data on-demand.
#'
#' @examples
#' \donttest{svc <- marketplacecommerceanalytics()
#' svc$generate_data_set(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=marketplacecommerceanalytics_generate_data_set]{generate_data_set} \tab Given a data set type and data set publication date, asynchronously publishes the requested data set to the specified S3 bucket and notifies the specified SNS topic once the data is available\cr
#'  \link[=marketplacecommerceanalytics_start_support_data_export]{start_support_data_export} \tab Given a data set type and a from date, asynchronously publishes the requested customer support data to the specified S3 bucket and notifies the specified SNS topic once the data is available 
#' }
#'
#' @rdname marketplacecommerceanalytics
#' @export
marketplacecommerceanalytics <- function() {
  .marketplacecommerceanalytics$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.marketplacecommerceanalytics <- list()

.marketplacecommerceanalytics$operations <- list()

.marketplacecommerceanalytics$metadata <- list(
  service_name = "marketplacecommerceanalytics",
  endpoints = list("*" = "marketplacecommerceanalytics.{region}.amazonaws.com", "cn-*" = "marketplacecommerceanalytics.{region}.amazonaws.com.cn"),
  service_id = "Marketplace Commerce Analytics",
  api_version = "2015-07-01",
  signing_name = "marketplacecommerceanalytics",
  json_version = "1.1",
  target_prefix = "MarketplaceCommerceAnalytics20150701"
)

.marketplacecommerceanalytics$handlers <- new_handlers("jsonrpc", "v4")

.marketplacecommerceanalytics$service <- function() {
  new_service(.marketplacecommerceanalytics$metadata, .marketplacecommerceanalytics$handlers)
}
