% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proton_operations.R
\name{proton_create_template_sync_config}
\alias{proton_create_template_sync_config}
\title{Set up a template to create new template versions automatically by
tracking a linked repository}
\usage{
proton_create_template_sync_config(
  branch,
  repositoryName,
  repositoryProvider,
  subdirectory = NULL,
  templateName,
  templateType
)
}
\arguments{
\item{branch}{[required] The repository branch for your template.}

\item{repositoryName}{[required] The repository name (for example, \code{myrepos/myrepo}).}

\item{repositoryProvider}{[required] The provider type for your repository.}

\item{subdirectory}{A repository subdirectory path to your template bundle directory. When
included, Proton limits the template bundle search to this repository
directory.}

\item{templateName}{[required] The name of your registered template.}

\item{templateType}{[required] The type of the registered template.}
}
\description{
Set up a template to create new template versions automatically by tracking a linked repository. A linked repository is a repository that has been registered with Proton. For more information, see \code{\link[=proton_create_repository]{create_repository}}.

See \url{https://www.paws-r-sdk.com/docs/proton_create_template_sync_config/} for full documentation.
}
\keyword{internal}
