% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_capacity_block_extension_history}
\alias{ec2_describe_capacity_block_extension_history}
\title{Describes the events for the specified Capacity Block extension during
the specified time}
\usage{
ec2_describe_capacity_block_extension_history(
  CapacityReservationIds = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  Filters = NULL,
  DryRun = NULL
)
}
\arguments{
\item{CapacityReservationIds}{The IDs of Capacity Block reservations that you want to display the
history for.}

\item{NextToken}{The token to use to retrieve the next page of results.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{Filters}{One or more filters
\itemize{
\item \code{availability-zone} - The Availability Zone of the extension.
\item \code{availability-zone-id} - The Availability Zone ID of the extension.
\item \code{capacity-block-extension-offering-id} - The ID of the extension
offering.
\item \code{capacity-block-extension-status} - The status of the extension
(\code{payment-pending} | \code{payment-failed} | \code{payment-succeeded}).
\item \code{capacity-reservation-id} - The reservation ID of the extension.
\item \code{instance-type} - The instance type of the extension.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the events for the specified Capacity Block extension during the specified time.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_capacity_block_extension_history/} for full documentation.
}
\keyword{internal}
