% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_register_container_image}
\alias{lightsail_register_container_image}
\title{Registers a container image to your Amazon Lightsail container service}
\usage{
lightsail_register_container_image(serviceName, label, digest)
}
\arguments{
\item{serviceName}{[required] The name of the container service for which to register a container
image.}

\item{label}{[required] The label for the container image when it's registered to the container
service.

Use a descriptive label that you can use to track the different versions
of your registered container images.

Use the \code{\link[=lightsail_get_container_images]{get_container_images}} action
to return the container images registered to a Lightsail container
service. The label is the \verb{<imagelabel>} portion of the following image
name example:
\itemize{
\item \verb{:container-service-1.<imagelabel>.1}
}

If the name of your container service is \code{mycontainerservice}, and the
label that you specify is \code{mystaticwebsite}, then the name of the
registered container image will be
\verb{:mycontainerservice.mystaticwebsite.1}.

The number at the end of these image name examples represents the
version of the registered container image. If you push and register
another container image to the same Lightsail container service, with
the same label, then the version number for the new registered container
image will be \code{2}. If you push and register another container image, the
version number will be \code{3}, and so on.}

\item{digest}{[required] The digest of the container image to be registered.}
}
\description{
Registers a container image to your Amazon Lightsail container service.

See \url{https://www.paws-r-sdk.com/docs/lightsail_register_container_image/} for full documentation.
}
\keyword{internal}
