% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeoptimizer_operations.R
\name{computeoptimizer_get_license_recommendations}
\alias{computeoptimizer_get_license_recommendations}
\title{Returns license recommendations for Amazon EC2 instances that run on a
specific license}
\usage{
computeoptimizer_get_license_recommendations(
  resourceArns = NULL,
  nextToken = NULL,
  maxResults = NULL,
  filters = NULL,
  accountIds = NULL
)
}
\arguments{
\item{resourceArns}{The ARN that identifies the Amazon EC2 instance.

The following is the format of the ARN:

\code{arn:aws:ec2:region:aws_account_id:instance/instance-id}}

\item{nextToken}{The token to advance to the next page of license recommendations.}

\item{maxResults}{The maximum number of license recommendations to return with a single
request.

To retrieve the remaining results, make another request with the
returned \code{nextToken} value.}

\item{filters}{An array of objects to specify a filter that returns a more specific
list of license recommendations.}

\item{accountIds}{The ID of the Amazon Web Services account for which to return license
recommendations.

If your account is the management account of an organization, use this
parameter to specify the member account for which you want to return
license recommendations.

Only one account ID can be specified per request.}
}
\description{
Returns license recommendations for Amazon EC2 instances that run on a specific license.

See \url{https://www.paws-r-sdk.com/docs/computeoptimizer_get_license_recommendations/} for full documentation.
}
\keyword{internal}
