% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_export_image}
\alias{ec2_export_image}
\title{Exports an Amazon Machine Image (AMI) to a VM file}
\usage{
ec2_export_image(
  ClientToken = NULL,
  Description = NULL,
  DiskImageFormat,
  DryRun = NULL,
  ImageId,
  S3ExportLocation,
  RoleName = NULL,
  TagSpecifications = NULL
)
}
\arguments{
\item{ClientToken}{Token to enable idempotency for export image requests.}

\item{Description}{A description of the image being exported. The maximum length is 255
characters.}

\item{DiskImageFormat}{[required] The disk image format.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ImageId}{[required] The ID of the image.}

\item{S3ExportLocation}{[required] The Amazon S3 bucket for the destination image. The destination bucket
must exist.}

\item{RoleName}{The name of the role that grants VM Import/Export permission to export
images to your Amazon S3 bucket. If this parameter is not specified, the
default role is named 'vmimport'.}

\item{TagSpecifications}{The tags to apply to the export image task during creation.}
}
\description{
Exports an Amazon Machine Image (AMI) to a VM file. For more information, see \href{https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport_image.html}{Exporting a VM directly from an Amazon Machine Image (AMI)} in the \emph{VM Import/Export User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_export_image/} for full documentation.
}
\keyword{internal}
