% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_release_ipam_pool_allocation}
\alias{ec2_release_ipam_pool_allocation}
\title{Release an allocation within an IPAM pool}
\usage{
ec2_release_ipam_pool_allocation(
  DryRun = NULL,
  IpamPoolId,
  Cidr,
  IpamPoolAllocationId
)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamPoolId}{[required] The ID of the IPAM pool which contains the allocation you want to
release.}

\item{Cidr}{[required] The CIDR of the allocation you want to release.}

\item{IpamPoolAllocationId}{[required] The ID of the allocation.}
}
\description{
Release an allocation within an IPAM pool. The Region you use should be the IPAM pool locale. The locale is the Amazon Web Services Region where this IPAM pool is available for allocations. You can only use this action to release manual allocations. To remove an allocation for a resource without deleting the resource, set its monitored state to false using \code{\link[=ec2_modify_ipam_resource_cidr]{modify_ipam_resource_cidr}}. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/}{Release an allocation} in the \emph{Amazon VPC IPAM User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_release_ipam_pool_allocation/} for full documentation.
}
\keyword{internal}
