% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_bucket_metric_data}
\alias{lightsail_get_bucket_metric_data}
\title{Returns the data points of a specific metric for an Amazon Lightsail
bucket}
\usage{
lightsail_get_bucket_metric_data(
  bucketName,
  metricName,
  startTime,
  endTime,
  period,
  statistics,
  unit
)
}
\arguments{
\item{bucketName}{[required] The name of the bucket for which to get metric data.}

\item{metricName}{[required] The metric for which you want to return information.

Valid bucket metric names are listed below, along with the most useful
statistics to include in your request, and the published unit value.

These bucket metrics are reported once per day.
\itemize{
\item \strong{\code{BucketSizeBytes}} - The amount of data in bytes stored in a
bucket. This value is calculated by summing the size of all objects
in the bucket (including object versions), including the size of all
parts for all incomplete multipart uploads to the bucket.

Statistics: The most useful statistic is \code{Maximum}.

Unit: The published unit is \code{Bytes}.
\item \strong{\code{NumberOfObjects}} - The total number of objects stored in a
bucket. This value is calculated by counting all objects in the
bucket (including object versions) and the total number of parts for
all incomplete multipart uploads to the bucket.

Statistics: The most useful statistic is \code{Average}.

Unit: The published unit is \code{Count}.
}}

\item{startTime}{[required] The timestamp indicating the earliest data to be returned.}

\item{endTime}{[required] The timestamp indicating the latest data to be returned.}

\item{period}{[required] The granularity, in seconds, of the returned data points.

Bucket storage metrics are reported once per day. Therefore, you should
specify a period of 86400 seconds, which is the number of seconds in a
day.}

\item{statistics}{[required] The statistic for the metric.

The following statistics are available:
\itemize{
\item \code{Minimum} - The lowest value observed during the specified period.
Use this value to determine low volumes of activity for your
application.
\item \code{Maximum} - The highest value observed during the specified period.
Use this value to determine high volumes of activity for your
application.
\item \code{Sum} - The sum of all values submitted for the matching metric. You
can use this statistic to determine the total volume of a metric.
\item \code{Average} - The value of \code{Sum} / \code{SampleCount} during the specified
period. By comparing this statistic with the \code{Minimum} and \code{Maximum}
values, you can determine the full scope of a metric and how close
the average use is to the \code{Minimum} and \code{Maximum} values. This
comparison helps you to know when to increase or decrease your
resources.
\item \code{SampleCount} - The count, or number, of data points used for the
statistical calculation.
}}

\item{unit}{[required] The unit for the metric data request.

Valid units depend on the metric data being requested. For the valid
units with each available metric, see the \code{metricName} parameter.}
}
\description{
Returns the data points of a specific metric for an Amazon Lightsail bucket.

See \url{https://paws-r.github.io/docs/lightsail/get_bucket_metric_data.html} for full documentation.
}
\keyword{internal}
