% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_deregister_job_definition}
\alias{batch_deregister_job_definition}
\title{Deregisters an AWS Batch job definition}
\usage{
batch_deregister_job_definition(jobDefinition)
}
\arguments{
\item{jobDefinition}{[required] The name and revision (\code{name:revision}) or full Amazon Resource Name
(ARN) of the job definition to deregister.}
}
\description{
Deregisters an AWS Batch job definition. Job definitions will be
permanently deleted after 180 days.
}
\section{Request syntax}{
\preformatted{svc$deregister_job_definition(
  jobDefinition = "string"
)
}
}

\examples{
\dontrun{
# This example deregisters a job definition called sleep10.
svc$deregister_job_definition(
  jobDefinition = "sleep10"
)
}

}
\keyword{internal}
