% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_describe_repositories}
\alias{ecr_describe_repositories}
\title{Describes image repositories in a registry}
\usage{
ecr_describe_repositories(registryId, repositoryNames, nextToken,
  maxResults)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the
repositories to be described. If you do not specify a registry, the
default registry is assumed.}

\item{repositoryNames}{A list of repositories to describe. If this parameter is omitted, then
all repositories in a registry are described.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{DescribeRepositories} request where \code{maxResults} was used and the
results exceeded the value of that parameter. Pagination continues from
the end of the previous results that returned the \code{nextToken} value.
This value is \code{null} when there are no more results to return. This
option cannot be used when you specify repositories with
\code{repositoryNames}.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{maxResults}{The maximum number of repository results returned by
\code{DescribeRepositories} in paginated output. When this parameter is used,
\code{DescribeRepositories} only returns \code{maxResults} results in a single
page along with a \code{nextToken} response element. The remaining results of
the initial request can be seen by sending another
\code{DescribeRepositories} request with the returned \code{nextToken} value. This
value can be between 1 and 1000. If this parameter is not used, then
\code{DescribeRepositories} returns up to 100 results and a \code{nextToken}
value, if applicable. This option cannot be used when you specify
repositories with \code{repositoryNames}.}
}
\description{
Describes image repositories in a registry.
}
\section{Request syntax}{
\preformatted{svc$describe_repositories(
  registryId = "string",
  repositoryNames = list(
    "string"
  ),
  nextToken = "string",
  maxResults = 123
)
}
}

\examples{
\dontrun{
# The following example obtains a list and description of all repositories
# in the default registry to which the current user has access.
svc$describe_repositories()
}

}
\keyword{internal}
