% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_transit_gateways}
\alias{ec2_describe_transit_gateways}
\title{Describes one or more transit gateways}
\usage{
ec2_describe_transit_gateways(TransitGatewayIds, Filters, MaxResults,
  NextToken, DryRun)
}
\arguments{
\item{TransitGatewayIds}{The IDs of the transit gateways.}

\item{Filters}{One or more filters. The possible values are:
\itemize{
\item \code{options.propagation-default-route-table-id} - The ID of the default
propagation route table.
\item \code{options.amazon-side-asn} - The private ASN for the Amazon side of a
BGP session.
\item \code{options.association-default-route-table-id} - The ID of the default
association route table.
\item \code{options.auto-accept-shared-attachments} - Indicates whether there
is automatic acceptance of attachment requests (\code{enable} \\|
\code{disable}).
\item \code{options.default-route-table-association} - Indicates whether
resource attachments are automatically associated with the default
association route table (\code{enable} \\| \code{disable}).
\item \code{options.default-route-table-propagation} - Indicates whether
resource attachments automatically propagate routes to the default
propagation route table (\code{enable} \\| \code{disable}).
\item \code{options.dns-support} - Indicates whether DNS support is enabled
(\code{enable} \\| \code{disable}).
\item \code{options.vpn-ecmp-support} - Indicates whether Equal Cost Multipath
Protocol support is enabled (\code{enable} \\| \code{disable}).
\item \code{owner-id} - The ID of the AWS account that owns the transit
gateway.
\item \code{state} - The state of the attachment (\code{available} \\| \code{deleted} \\|
\code{deleting} \\| \code{failed} \\| \code{modifying} \\| \code{pendingAcceptance} \\|
\code{pending} \\| \code{rollingBack} \\| \code{rejected} \\| \code{rejecting}).
\item \code{transit-gateway-id} - The ID of the transit gateway.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes one or more transit gateways. By default, all transit gateways
are described. Alternatively, you can filter the results.
}
\section{Request syntax}{
\preformatted{svc$describe_transit_gateways(
  TransitGatewayIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
