% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_search_transit_gateway_routes}
\alias{ec2_search_transit_gateway_routes}
\title{Searches for routes in the specified transit gateway route table}
\usage{
ec2_search_transit_gateway_routes(TransitGatewayRouteTableId, Filters,
  MaxResults, DryRun)
}
\arguments{
\item{TransitGatewayRouteTableId}{[required] The ID of the transit gateway route table.}

\item{Filters}{[required] One or more filters. The possible values are:
\itemize{
\item \code{attachment.transit-gateway-attachment-id}- The id of the transit
gateway attachment.
\item \code{attachment.resource-id} - The resource id of the transit gateway
attachment.
\item \code{attachment.resource-type} - The attachment resource type (\code{vpc} \|
\code{vpn}).
\item \code{route-search.exact-match} - The exact match of the specified
filter.
\item \code{route-search.longest-prefix-match} - The longest prefix that
matches the route.
\item \code{route-search.subnet-of-match} - The routes with a subnet that match
the specified CIDR filter.
\item \code{route-search.supernet-of-match} - The routes with a CIDR that
encompass the CIDR filter. For example, if you have 10.0.1.0/29 and
10.0.1.0/31 routes in your route table and you specify
supernet-of-match as 10.0.1.0/30, then the result returns
10.0.1.0/29.
\item \code{state} - The state of the route (\code{active} \| \code{blackhole}).
\item \code{type} - The type of roue (\code{propagated} \| \code{static}).
}}

\item{MaxResults}{The maximum number of routes to return.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Searches for routes in the specified transit gateway route table.
}
\section{Request syntax}{
\preformatted{svc$search_transit_gateway_routes(
  TransitGatewayRouteTableId = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
