% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_key_pairs}
\alias{ec2_describe_key_pairs}
\title{Describes the specified key pairs or all of your key pairs}
\usage{
ec2_describe_key_pairs(Filters, KeyNames, DryRun)
}
\arguments{
\item{Filters}{The filters.
\itemize{
\item \code{fingerprint} - The fingerprint of the key pair.
\item \code{key-name} - The name of the key pair.
}}

\item{KeyNames}{The key pair names.

Default: Describes all your key pairs.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the specified key pairs or all of your key pairs.
}
\details{
For more information about key pairs, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html}{Key Pairs}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_key_pairs(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  KeyNames = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example displays the fingerprint for the specified key.
\donttest{svc$describe_key_pairs(
  KeyNames = list(
    "my-key-pair"
  )
)}

}
\keyword{internal}
