% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_delete_cluster}
\alias{eks_delete_cluster}
\title{Deletes the Amazon EKS cluster control plane}
\usage{
eks_delete_cluster(name)
}
\arguments{
\item{name}{[required] The name of the cluster to delete.}
}
\value{
A list with the following syntax:\preformatted{list(
  cluster = list(
    name = "string",
    arn = "string",
    createdAt = as.POSIXct(
      "2015-01-01"
    ),
    version = "string",
    endpoint = "string",
    roleArn = "string",
    resourcesVpcConfig = list(
      subnetIds = list(
        "string"
      ),
      securityGroupIds = list(
        "string"
      ),
      clusterSecurityGroupId = "string",
      vpcId = "string",
      endpointPublicAccess = TRUE|FALSE,
      endpointPrivateAccess = TRUE|FALSE,
      publicAccessCidrs = list(
        "string"
      )
    ),
    kubernetesNetworkConfig = list(
      serviceIpv4Cidr = "string"
    ),
    logging = list(
      clusterLogging = list(
        list(
          types = list(
            "api"|"audit"|"authenticator"|"controllerManager"|"scheduler"
          ),
          enabled = TRUE|FALSE
        )
      )
    ),
    identity = list(
      oidc = list(
        issuer = "string"
      )
    ),
    status = "CREATING"|"ACTIVE"|"DELETING"|"FAILED"|"UPDATING",
    certificateAuthority = list(
      data = "string"
    ),
    clientRequestToken = "string",
    platformVersion = "string",
    tags = list(
      "string"
    ),
    encryptionConfig = list(
      list(
        resources = list(
          "string"
        ),
        provider = list(
          keyArn = "string"
        )
      )
    )
  )
)
}
}
\description{
Deletes the Amazon EKS cluster control plane.

If you have active services in your cluster that are associated with a
load balancer, you must delete those services before deleting the
cluster so that the load balancers are deleted properly. Otherwise, you
can have orphaned resources in your VPC that prevent you from being able
to delete the VPC. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html}{Deleting a Cluster}
in the \emph{Amazon EKS User Guide}.

If you have managed node groups or Fargate profiles attached to the
cluster, you must delete them first. For more information, see
\code{\link[=eks_delete_nodegroup]{delete_nodegroup}} and
\code{\link[=eks_delete_fargate_profile]{delete_fargate_profile}}.
}
\section{Request syntax}{
\preformatted{svc$delete_cluster(
  name = "string"
)
}
}

\examples{
\dontrun{
# This example command deletes a cluster named `devel` in your default
# region.
svc$delete_cluster(
  name = "devel"
)
}

}
\keyword{internal}
