% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpc_endpoint}
\alias{ec2_create_vpc_endpoint}
\title{Creates a VPC endpoint for a specified service}
\usage{
ec2_create_vpc_endpoint(DryRun, VpcEndpointType, VpcId, ServiceName,
  PolicyDocument, RouteTableIds, SubnetIds, SecurityGroupIds, ClientToken,
  PrivateDnsEnabled, TagSpecifications)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcEndpointType}{The type of endpoint.

Default: Gateway}

\item{VpcId}{[required] The ID of the VPC in which the endpoint will be used.}

\item{ServiceName}{[required] The service name. To get a list of available services, use the
\code{\link[=ec2_describe_vpc_endpoint_services]{describe_vpc_endpoint_services}}
request, or get the name from the service provider.}

\item{PolicyDocument}{(Interface and gateway endpoints) A policy to attach to the endpoint
that controls access to the service. The policy must be in valid JSON
format. If this parameter is not specified, we attach a default policy
that allows full access to the service.}

\item{RouteTableIds}{(Gateway endpoint) One or more route table IDs.}

\item{SubnetIds}{(Interface and Gateway Load Balancer endpoints) The ID of one or more
subnets in which to create an endpoint network interface. For a Gateway
Load Balancer endpoint, you can specify one subnet only.}

\item{SecurityGroupIds}{(Interface endpoint) The ID of one or more security groups to associate
with the endpoint network interface.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to Ensure Idempotency}.}

\item{PrivateDnsEnabled}{(Interface endpoint) Indicates whether to associate a private hosted
zone with the specified VPC. The private hosted zone contains a record
set for the default public DNS name for the service for the Region (for
example, \verb{kinesis.us-east-1.amazonaws.com}), which resolves to the
private IP addresses of the endpoint network interfaces in the VPC. This
enables you to make requests to the default public DNS name for the
service instead of the public DNS names that are automatically generated
by the VPC endpoint service.

To use a private hosted zone, you must set the following VPC attributes
to \code{true}: \code{enableDnsHostnames} and \code{enableDnsSupport}. Use
\code{\link[=ec2_modify_vpc_attribute]{modify_vpc_attribute}} to set the VPC
attributes.

Default: \code{true}}

\item{TagSpecifications}{The tags to associate with the endpoint.}
}
\value{
A list with the following syntax:\preformatted{list(
  VpcEndpoint = list(
    VpcEndpointId = "string",
    VpcEndpointType = "Interface"|"Gateway"|"GatewayLoadBalancer",
    VpcId = "string",
    ServiceName = "string",
    State = "PendingAcceptance"|"Pending"|"Available"|"Deleting"|"Deleted"|"Rejected"|"Failed"|"Expired",
    PolicyDocument = "string",
    RouteTableIds = list(
      "string"
    ),
    SubnetIds = list(
      "string"
    ),
    Groups = list(
      list(
        GroupId = "string",
        GroupName = "string"
      )
    ),
    PrivateDnsEnabled = TRUE|FALSE,
    RequesterManaged = TRUE|FALSE,
    NetworkInterfaceIds = list(
      "string"
    ),
    DnsEntries = list(
      list(
        DnsName = "string",
        HostedZoneId = "string"
      )
    ),
    CreationTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    OwnerId = "string",
    LastError = list(
      Message = "string",
      Code = "string"
    )
  ),
  ClientToken = "string"
)
}
}
\description{
Creates a VPC endpoint for a specified service. An endpoint enables you
to create a private connection between your VPC and the service. The
service may be provided by AWS, an AWS Marketplace Partner, or another
AWS account. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/privatelink/vpc-endpoints.html}{VPC Endpoints}
in the \emph{Amazon Virtual Private Cloud User Guide}.

A \code{gateway} endpoint serves as a target for a route in your route table
for traffic destined for the AWS service. You can specify an endpoint
policy to attach to the endpoint, which will control access to the
service from your VPC. You can also specify the VPC route tables that
use the endpoint.

An \code{interface} endpoint is a network interface in your subnet that
serves as an endpoint for communicating with the specified service. You
can specify the subnets in which to create an endpoint, and the security
groups to associate with the endpoint network interface.

A \code{GatewayLoadBalancer} endpoint is a network interface in your subnet
that serves an endpoint for communicating with a Gateway Load Balancer
that you've configured as a VPC endpoint service.

Use
\code{\link[=ec2_describe_vpc_endpoint_services]{describe_vpc_endpoint_services}}
to get a list of supported services.
}
\section{Request syntax}{
\preformatted{svc$create_vpc_endpoint(
  DryRun = TRUE|FALSE,
  VpcEndpointType = "Interface"|"Gateway"|"GatewayLoadBalancer",
  VpcId = "string",
  ServiceName = "string",
  PolicyDocument = "string",
  RouteTableIds = list(
    "string"
  ),
  SubnetIds = list(
    "string"
  ),
  SecurityGroupIds = list(
    "string"
  ),
  ClientToken = "string",
  PrivateDnsEnabled = TRUE|FALSE,
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\keyword{internal}
