% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_get_layer_version_by_arn}
\alias{lambda_get_layer_version_by_arn}
\title{Returns information about a version of an AWS Lambda layer, with a link
to download the layer archive that's valid for 10 minutes}
\usage{
lambda_get_layer_version_by_arn(Arn)
}
\arguments{
\item{Arn}{[required] The ARN of the layer version.}
}
\value{
A list with the following syntax:\preformatted{list(
  Content = list(
    Location = "string",
    CodeSha256 = "string",
    CodeSize = 123,
    SigningProfileVersionArn = "string",
    SigningJobArn = "string"
  ),
  LayerArn = "string",
  LayerVersionArn = "string",
  Description = "string",
  CreatedDate = "string",
  Version = 123,
  CompatibleRuntimes = list(
    "nodejs"|"nodejs4.3"|"nodejs6.10"|"nodejs8.10"|"nodejs10.x"|"nodejs12.x"|"java8"|"java8.al2"|"java11"|"python2.7"|"python3.6"|"python3.7"|"python3.8"|"dotnetcore1.0"|"dotnetcore2.0"|"dotnetcore2.1"|"dotnetcore3.1"|"nodejs4.3-edge"|"go1.x"|"ruby2.5"|"ruby2.7"|"provided"|"provided.al2"
  ),
  LicenseInfo = "string"
)
}
}
\description{
Returns information about a version of an \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{AWS Lambda layer},
with a link to download the layer archive that's valid for 10 minutes.
}
\section{Request syntax}{
\preformatted{svc$get_layer_version_by_arn(
  Arn = "string"
)
}
}

\examples{
\dontrun{
# The following example returns information about the layer version with
# the specified Amazon Resource Name (ARN).
svc$get_layer_version_by_arn(
  Arn = "arn:aws:lambda:ca-central-1:123456789012:layer:blank-python-lib:3"
)
}

}
\keyword{internal}
