% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_instance_access_details}
\alias{lightsail_get_instance_access_details}
\title{Returns temporary SSH keys you can use to connect to a specific virtual
private server, or instance}
\usage{
lightsail_get_instance_access_details(instanceName, protocol)
}
\arguments{
\item{instanceName}{[required] The name of the instance to access.}

\item{protocol}{The protocol to use to connect to your instance. Defaults to \code{ssh}.}
}
\value{
A list with the following syntax:\preformatted{list(
  accessDetails = list(
    certKey = "string",
    expiresAt = as.POSIXct(
      "2015-01-01"
    ),
    ipAddress = "string",
    password = "string",
    passwordData = list(
      ciphertext = "string",
      keyPairName = "string"
    ),
    privateKey = "string",
    protocol = "ssh"|"rdp",
    instanceName = "string",
    username = "string",
    hostKeys = list(
      list(
        algorithm = "string",
        publicKey = "string",
        witnessedAt = as.POSIXct(
          "2015-01-01"
        ),
        fingerprintSHA1 = "string",
        fingerprintSHA256 = "string",
        notValidBefore = as.POSIXct(
          "2015-01-01"
        ),
        notValidAfter = as.POSIXct(
          "2015-01-01"
        )
      )
    )
  )
)
}
}
\description{
Returns temporary SSH keys you can use to connect to a specific virtual
private server, or \emph{instance}.

The \verb{get instance access details} operation supports tag-based access
control via resource tags applied to the resource identified by
\verb{instance name}. For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$get_instance_access_details(
  instanceName = "string",
  protocol = "ssh"|"rdp"
)
}
}

\keyword{internal}
