% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_nat_gateways}
\alias{ec2_describe_nat_gateways}
\title{Describes one or more of your NAT gateways}
\usage{
ec2_describe_nat_gateways(DryRun, Filter, MaxResults, NatGatewayIds,
  NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filter}{One or more filters.
\itemize{
\item \code{nat-gateway-id} - The ID of the NAT gateway.
\item \code{state} - The state of the NAT gateway (\code{pending} | \code{failed} |
\code{available} | \code{deleting} | \code{deleted}).
\item \code{subnet-id} - The ID of the subnet in which the NAT gateway resides.
\item \code{tag}:<key> - The key/value combination of a tag assigned to
the resource. Use the tag key in the filter name and the tag value
as the filter value. For example, to find all resources that have a
tag with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner}
for the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{vpc-id} - The ID of the VPC in which the NAT gateway resides.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NatGatewayIds}{One or more NAT gateway IDs.}

\item{NextToken}{The token for the next page of results.}
}
\description{
Describes one or more of your NAT gateways.
}
\section{Request syntax}{
\preformatted{svc$describe_nat_gateways(
  DryRun = TRUE|FALSE,
  Filter = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NatGatewayIds = list(
    "string"
  ),
  NextToken = "string"
)
}
}

\examples{
\dontrun{
# This example describes the NAT gateway for the specified VPC.
svc$describe_nat_gateways(
  Filter = list(
    list(
      Name = "vpc-id",
      Values = list(
        "vpc-1a2b3c4d"
      )
    )
  )
)
}

}
\keyword{internal}
