% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_list_container_instances}
\alias{ecs_list_container_instances}
\title{Returns a list of container instances in a specified cluster}
\usage{
ecs_list_container_instances(cluster, filter, nextToken, maxResults,
  status)
}
\arguments{
\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the container instances to list. If you do not specify a cluster,
the default cluster is assumed.}

\item{filter}{You can filter the results of a \code{ListContainerInstances} operation with
cluster query language statements. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html}{Cluster Query Language}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{ListContainerInstances} request where \code{maxResults} was used and the
results exceeded the value of that parameter. Pagination continues from
the end of the previous results that returned the \code{nextToken} value.

This token should be treated as an opaque identifier that is only used
to retrieve the next items in a list and not for other programmatic
purposes.}

\item{maxResults}{The maximum number of container instance results returned by
\code{ListContainerInstances} in paginated output. When this parameter is
used, \code{ListContainerInstances} only returns \code{maxResults} results in a
single page along with a \code{nextToken} response element. The remaining
results of the initial request can be seen by sending another
\code{ListContainerInstances} request with the returned \code{nextToken} value.
This value can be between 1 and 100. If this parameter is not used, then
\code{ListContainerInstances} returns up to 100 results and a \code{nextToken}
value if applicable.}

\item{status}{Filters the container instances by status. For example, if you specify
the \code{DRAINING} status, the results include only container instances that
have been set to \code{DRAINING} using UpdateContainerInstancesState. If you
do not specify this parameter, the default is to include container
instances set to \code{ACTIVE} and \code{DRAINING}.}
}
\description{
Returns a list of container instances in a specified cluster. You can
filter the results of a \code{ListContainerInstances} operation with cluster
query language statements inside the \code{filter} parameter. For more
information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html}{Cluster Query Language}
in the \emph{Amazon Elastic Container Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_container_instances(
  cluster = "string",
  filter = "string",
  nextToken = "string",
  maxResults = 123,
  status = "ACTIVE"|"DRAINING"
)
}
}

\examples{
# This example lists all of your available container instances in the
# specified cluster in your default region.
\donttest{svc$list_container_instances(
  cluster = "default"
)}

}
\keyword{internal}
