% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mq_operations.R
\name{mq_create_broker}
\alias{mq_create_broker}
\title{Creates a broker}
\usage{
mq_create_broker(
  AuthenticationStrategy = NULL,
  AutoMinorVersionUpgrade,
  BrokerName,
  Configuration = NULL,
  CreatorRequestId = NULL,
  DeploymentMode,
  EncryptionOptions = NULL,
  EngineType,
  EngineVersion,
  HostInstanceType,
  LdapServerMetadata = NULL,
  Logs = NULL,
  MaintenanceWindowStartTime = NULL,
  PubliclyAccessible,
  SecurityGroups = NULL,
  StorageType = NULL,
  SubnetIds = NULL,
  Tags = NULL,
  Users
)
}
\arguments{
\item{AuthenticationStrategy}{Optional. The authentication strategy used to secure the broker. The
default is SIMPLE.}

\item{AutoMinorVersionUpgrade}{[required] Enables automatic upgrades to new minor versions for brokers, as new
versions are released and supported by Amazon MQ. Automatic upgrades
occur during the scheduled maintenance window of the broker or after a
manual broker reboot. Set to true by default, if no value is specified.}

\item{BrokerName}{[required] Required. The broker's name. This value must be unique in your AWS
account, 1-50 characters long, must contain only letters, numbers,
dashes, and underscores, and must not contain white spaces, brackets,
wildcard characters, or special characters.}

\item{Configuration}{A list of information about the configuration.}

\item{CreatorRequestId}{The unique ID that the requester receives for the created broker. Amazon
MQ passes your ID with the API action. Note: We recommend using a
Universally Unique Identifier (UUID) for the creatorRequestId. You may
omit the creatorRequestId if your application doesn't require
idempotency.}

\item{DeploymentMode}{[required] Required. The broker's deployment mode.}

\item{EncryptionOptions}{Encryption options for the broker. Does not apply to RabbitMQ brokers.}

\item{EngineType}{[required] Required. The type of broker engine. Currently, Amazon MQ supports
ACTIVEMQ and RABBITMQ.}

\item{EngineVersion}{[required] Required. The broker engine's version. For a list of supported engine
versions, see \href{https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/}{Supported engines}.}

\item{HostInstanceType}{[required] Required. The broker's instance type.}

\item{LdapServerMetadata}{Optional. The metadata of the LDAP server used to authenticate and
authorize connections to the broker. Does not apply to RabbitMQ brokers.}

\item{Logs}{Enables Amazon CloudWatch logging for brokers.}

\item{MaintenanceWindowStartTime}{The parameters that determine the WeeklyStartTime.}

\item{PubliclyAccessible}{[required] Enables connections from applications outside of the VPC that hosts the
broker's subnets. Set to false by default, if no value is provided.}

\item{SecurityGroups}{The list of rules (1 minimum, 125 maximum) that authorize connections to
brokers.}

\item{StorageType}{The broker's storage type.}

\item{SubnetIds}{The list of groups that define which subnets and IP ranges the broker
can use from different Availability Zones. If you specify more than one
subnet, the subnets must be in different Availability Zones. Amazon MQ
will not be able to create VPC endpoints for your broker with multiple
subnets in the same Availability Zone. A SINGLE_INSTANCE deployment
requires one subnet (for example, the default subnet). An
ACTIVE_STANDBY_MULTI_AZ Amazon MQ for ActiveMQ deployment requires two
subnets. A CLUSTER_MULTI_AZ Amazon MQ for RabbitMQ deployment has no
subnet requirements when deployed with public accessibility. Deployment
without public accessibility requires at least one subnet.

If you specify subnets in a \href{https://docs.aws.amazon.com/vpc/latest/userguide/vpc-sharing.html}{shared VPC}
for a RabbitMQ broker, the associated VPC to which the specified subnets
belong must be owned by your AWS account. Amazon MQ will not be able to
create VPC endpoints in VPCs that are not owned by your AWS account.}

\item{Tags}{Create tags when creating the broker.}

\item{Users}{[required] Required. The list of broker users (persons or applications) who can
access queues and topics. This value can contain only alphanumeric
characters, dashes, periods, underscores, and tildes (- . _ ~). This
value must be 2-100 characters long.

Amazon MQ for RabbitMQ

When you create an Amazon MQ for RabbitMQ broker, one and only one
administrative user is accepted and created when a broker is first
provisioned. All subsequent broker users are created by making RabbitMQ
API calls directly to brokers or via the RabbitMQ web console.}
}
\description{
Creates a broker. Note: This API is asynchronous.

See \url{https://paws-r.github.io/docs/mq/create_broker.html} for full documentation.
}
\keyword{internal}
