% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_operations.R
\name{locationservice_tag_resource}
\alias{locationservice_tag_resource}
\title{Assigns one or more tags (key-value pairs) to the specified Amazon
Location Service resource}
\usage{
locationservice_tag_resource(ResourceArn, Tags)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource whose tags you want to
update.
\itemize{
\item Format example:
\code{arn:aws:geo:region:account-id:resourcetype/ExampleResource}
}}

\item{Tags}{[required] Applies one or more tags to specific resource. A tag is a key-value pair
that helps you manage, identify, search, and filter your resources.

Format: \code{"key" : "value"}

Restrictions:
\itemize{
\item Maximum 50 tags per resource.
\item Each tag key must be unique and must have exactly one associated
value.
\item Maximum key length: 128 Unicode characters in UTF-8.
\item Maximum value length: 256 Unicode characters in UTF-8.
\item Can use alphanumeric characters (A–Z, a–z, 0–9), and the following
characters: + - = . _ : / @
\item Cannot use "aws:" as a prefix for a key.
}}
}
\description{
Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource.

See \url{https://paws-r.github.io/docs/locationservice/tag_resource.html} for full documentation.
}
\keyword{internal}
