% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_start_execution}
\alias{sfn_start_execution}
\title{Starts a state machine execution}
\usage{
sfn_start_execution(stateMachineArn, name, input, traceHeader)
}
\arguments{
\item{stateMachineArn}{[required] The Amazon Resource Name (ARN) of the state machine to execute.}

\item{name}{The name of the execution. This name must be unique for your AWS
account, region, and state machine for 90 days. For more information,
see \href{https://docs.aws.amazon.com/step-functions/latest/dg/limits-overview.html#service-limits-state-machine-executions}{Limits Related to State Machine Executions}
in the \emph{AWS Step Functions Developer Guide}.

A name must \emph{not} contain:
\itemize{
\item white space
\item brackets \verb{< > \{ \} [ ]}
\item wildcard characters \verb{? *}
\item special characters \verb{\\" # \% \\ ^ | ~ \\` $ & , ; : /}
\item control characters (\verb{U+0000-001F}, \verb{U+007F-009F})
}

To enable logging with CloudWatch Logs, the name should only contain
0-9, A-Z, a-z, - and _.

[ ]: R:\%20}

\item{input}{The string that contains the JSON input data for the execution, for
example:

\verb{"input": "\{\\"first_name\\" : \\"test\\"\}"}

If you don't include any JSON input data, you still must include the two
braces, for example: \code{"input": "{}"}

Length constraints apply to the payload size, and are expressed as bytes
in UTF-8 encoding.}

\item{traceHeader}{Passes the AWS X-Ray trace header. The trace header can also be passed
in the request payload.}
}
\value{
A list with the following syntax:\preformatted{list(
  executionArn = "string",
  startDate = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Starts a state machine execution.

\code{\link[=sfn_start_execution]{start_execution}} is idempotent. If
\code{\link[=sfn_start_execution]{start_execution}} is called with the same name
and input as a running execution, the call will succeed and return the
same response as the original request. If the execution is closed or if
the input is different, it will return a 400 \code{ExecutionAlreadyExists}
error. Names can be reused after 90 days.
}
\section{Request syntax}{
\preformatted{svc$start_execution(
  stateMachineArn = "string",
  name = "string",
  input = "string",
  traceHeader = "string"
)
}
}

\keyword{internal}
