# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include elasticsearchservice_service.R
NULL

#' Allows the destination domain owner to accept an inbound cross-cluster
#' search connection request
#'
#' @description
#' Allows the destination domain owner to accept an inbound cross-cluster search connection request.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_accept_inbound_cross_cluster_search_connection/](https://www.paws-r-sdk.com/docs/elasticsearchservice_accept_inbound_cross_cluster_search_connection/) for full documentation.
#'
#' @param CrossClusterSearchConnectionId &#91;required&#93; The id of the inbound connection that you want to accept.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_accep_inbou_cross_clust_searc_conne
elasticsearchservice_accept_inbound_cross_cluster_search_connection <- function(CrossClusterSearchConnectionId) {
  op <- new_operation(
    name = "AcceptInboundCrossClusterSearchConnection",
    http_method = "PUT",
    http_path = "/2015-01-01/es/ccs/inboundConnection/{ConnectionId}/accept",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$accept_inbound_cross_cluster_search_connection_input(CrossClusterSearchConnectionId = CrossClusterSearchConnectionId)
  output <- .elasticsearchservice$accept_inbound_cross_cluster_search_connection_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$accept_inbound_cross_cluster_search_connection <- elasticsearchservice_accept_inbound_cross_cluster_search_connection

#' Attaches tags to an existing Elasticsearch domain
#'
#' @description
#' Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive key value pairs. An Elasticsearch domain may have up to 10 tags. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/#es-managedomains-awsresorcetagging" target="_blank">Tagging Amazon Elasticsearch Service Domains for more information.</a>
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_add_tags/](https://www.paws-r-sdk.com/docs/elasticsearchservice_add_tags/) for full documentation.
#'
#' @param ARN &#91;required&#93; Specify the `ARN` for which you want to add the tags.
#' @param TagList &#91;required&#93; List of `Tag` that need to be added for the Elasticsearch domain.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_add_tags
elasticsearchservice_add_tags <- function(ARN, TagList) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/2015-01-01/tags",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$add_tags_input(ARN = ARN, TagList = TagList)
  output <- .elasticsearchservice$add_tags_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$add_tags <- elasticsearchservice_add_tags

#' Associates a package with an Amazon ES domain
#'
#' @description
#' Associates a package with an Amazon ES domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_associate_package/](https://www.paws-r-sdk.com/docs/elasticsearchservice_associate_package/) for full documentation.
#'
#' @param PackageID &#91;required&#93; Internal ID of the package that you want to associate with a domain. Use
#' [`describe_packages`][elasticsearchservice_describe_packages] to find
#' this value.
#' @param DomainName &#91;required&#93; Name of the domain that you want to associate the package with.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_associate_package
elasticsearchservice_associate_package <- function(PackageID, DomainName) {
  op <- new_operation(
    name = "AssociatePackage",
    http_method = "POST",
    http_path = "/2015-01-01/packages/associate/{PackageID}/{DomainName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$associate_package_input(PackageID = PackageID, DomainName = DomainName)
  output <- .elasticsearchservice$associate_package_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$associate_package <- elasticsearchservice_associate_package

#' Provides access to an Amazon OpenSearch Service domain through the use
#' of an interface VPC endpoint
#'
#' @description
#' Provides access to an Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_authorize_vpc_endpoint_access/](https://www.paws-r-sdk.com/docs/elasticsearchservice_authorize_vpc_endpoint_access/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the OpenSearch Service domain to provide access to.
#' @param Account &#91;required&#93; The account ID to grant access to.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_authorize_vpc_endpoint_access
elasticsearchservice_authorize_vpc_endpoint_access <- function(DomainName, Account) {
  op <- new_operation(
    name = "AuthorizeVpcEndpointAccess",
    http_method = "POST",
    http_path = "/2015-01-01/es/domain/{DomainName}/authorizeVpcEndpointAccess",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$authorize_vpc_endpoint_access_input(DomainName = DomainName, Account = Account)
  output <- .elasticsearchservice$authorize_vpc_endpoint_access_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$authorize_vpc_endpoint_access <- elasticsearchservice_authorize_vpc_endpoint_access

#' Cancels a pending configuration change on an Amazon OpenSearch Service
#' domain
#'
#' @description
#' Cancels a pending configuration change on an Amazon OpenSearch Service domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_cancel_domain_config_change/](https://www.paws-r-sdk.com/docs/elasticsearchservice_cancel_domain_config_change/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Name of the OpenSearch Service domain configuration request to cancel.
#' @param DryRun When set to **True**, returns the list of change IDs and properties that
#' will be cancelled without actually cancelling the change.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_cancel_domain_config_change
elasticsearchservice_cancel_domain_config_change <- function(DomainName, DryRun = NULL) {
  op <- new_operation(
    name = "CancelDomainConfigChange",
    http_method = "POST",
    http_path = "/2015-01-01/es/domain/{DomainName}/config/cancel",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$cancel_domain_config_change_input(DomainName = DomainName, DryRun = DryRun)
  output <- .elasticsearchservice$cancel_domain_config_change_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$cancel_domain_config_change <- elasticsearchservice_cancel_domain_config_change

#' Cancels a scheduled service software update for an Amazon ES domain
#'
#' @description
#' Cancels a scheduled service software update for an Amazon ES domain. You can only perform this operation before the `AutomatedUpdateDate` and when the `UpdateStatus` is in the `PENDING_UPDATE` state.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_cancel_elasticsearch_service_software_update/](https://www.paws-r-sdk.com/docs/elasticsearchservice_cancel_elasticsearch_service_software_update/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to stop the latest service software
#' update on.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_cance_elast_servi_softw_updat
elasticsearchservice_cancel_elasticsearch_service_software_update <- function(DomainName) {
  op <- new_operation(
    name = "CancelElasticsearchServiceSoftwareUpdate",
    http_method = "POST",
    http_path = "/2015-01-01/es/serviceSoftwareUpdate/cancel",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$cancel_elasticsearch_service_software_update_input(DomainName = DomainName)
  output <- .elasticsearchservice$cancel_elasticsearch_service_software_update_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$cancel_elasticsearch_service_software_update <- elasticsearchservice_cancel_elasticsearch_service_software_update

#' Creates a new Elasticsearch domain
#'
#' @description
#' Creates a new Elasticsearch domain. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#es-createdomains" target="_blank">Creating Elasticsearch Domains</a> in the *Amazon Elasticsearch Service Developer Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_create_elasticsearch_domain/](https://www.paws-r-sdk.com/docs/elasticsearchservice_create_elasticsearch_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the Elasticsearch domain that you are creating. Domain names
#' are unique across the domains owned by an account within an AWS region.
#' Domain names must start with a lowercase letter and can contain the
#' following characters: a-z (lowercase), 0-9, and - (hyphen).
#' @param ElasticsearchVersion String of format X.Y to specify version for the Elasticsearch domain eg.
#' "1.5" or "2.3". For more information, see <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#es-createdomains"
#' target="_blank">Creating Elasticsearch Domains</a> in the *Amazon
#' Elasticsearch Service Developer Guide*.
#' @param ElasticsearchClusterConfig Configuration options for an Elasticsearch domain. Specifies the
#' instance type and number of instances in the domain cluster.
#' @param EBSOptions Options to enable, disable and specify the type and size of EBS storage
#' volumes.
#' @param AccessPolicies IAM access policy as a JSON-formatted string.
#' @param SnapshotOptions Option to set time, in UTC format, of the daily automated snapshot.
#' Default value is 0 hours.
#' @param VPCOptions Options to specify the subnets and security groups for VPC endpoint. For
#' more information, see <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html#es-creating-vpc"
#' target="_blank">Creating a VPC</a> in *VPC Endpoints for Amazon
#' Elasticsearch Service Domains*
#' @param CognitoOptions Options to specify the Cognito user and identity pools for Kibana
#' authentication. For more information, see <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
#' target="_blank">Amazon Cognito Authentication for Kibana</a>.
#' @param EncryptionAtRestOptions Specifies the Encryption At Rest Options.
#' @param NodeToNodeEncryptionOptions Specifies the NodeToNodeEncryptionOptions.
#' @param AdvancedOptions Option to allow references to indices in an HTTP request body. Must be
#' `false` when configuring access to individual sub-resources. By default,
#' the value is `true`. See <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#es-createdomain-configure-advanced-options"
#' target="_blank">Configuration Advanced Options</a> for more information.
#' @param LogPublishingOptions Map of `LogType` and `LogPublishingOption`, each containing options to
#' publish a given type of Elasticsearch log.
#' @param DomainEndpointOptions Options to specify configuration that will be applied to the domain
#' endpoint.
#' @param AdvancedSecurityOptions Specifies advanced security options.
#' @param AutoTuneOptions Specifies Auto-Tune options.
#' @param TagList A list of `Tag` added during domain creation.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_create_elasticsearch_domain
elasticsearchservice_create_elasticsearch_domain <- function(DomainName, ElasticsearchVersion = NULL, ElasticsearchClusterConfig = NULL, EBSOptions = NULL, AccessPolicies = NULL, SnapshotOptions = NULL, VPCOptions = NULL, CognitoOptions = NULL, EncryptionAtRestOptions = NULL, NodeToNodeEncryptionOptions = NULL, AdvancedOptions = NULL, LogPublishingOptions = NULL, DomainEndpointOptions = NULL, AdvancedSecurityOptions = NULL, AutoTuneOptions = NULL, TagList = NULL) {
  op <- new_operation(
    name = "CreateElasticsearchDomain",
    http_method = "POST",
    http_path = "/2015-01-01/es/domain",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$create_elasticsearch_domain_input(DomainName = DomainName, ElasticsearchVersion = ElasticsearchVersion, ElasticsearchClusterConfig = ElasticsearchClusterConfig, EBSOptions = EBSOptions, AccessPolicies = AccessPolicies, SnapshotOptions = SnapshotOptions, VPCOptions = VPCOptions, CognitoOptions = CognitoOptions, EncryptionAtRestOptions = EncryptionAtRestOptions, NodeToNodeEncryptionOptions = NodeToNodeEncryptionOptions, AdvancedOptions = AdvancedOptions, LogPublishingOptions = LogPublishingOptions, DomainEndpointOptions = DomainEndpointOptions, AdvancedSecurityOptions = AdvancedSecurityOptions, AutoTuneOptions = AutoTuneOptions, TagList = TagList)
  output <- .elasticsearchservice$create_elasticsearch_domain_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$create_elasticsearch_domain <- elasticsearchservice_create_elasticsearch_domain

#' Creates a new cross-cluster search connection from a source domain to a
#' destination domain
#'
#' @description
#' Creates a new cross-cluster search connection from a source domain to a destination domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_create_outbound_cross_cluster_search_connection/](https://www.paws-r-sdk.com/docs/elasticsearchservice_create_outbound_cross_cluster_search_connection/) for full documentation.
#'
#' @param SourceDomainInfo &#91;required&#93; Specifies the `DomainInformation` for the source Elasticsearch domain.
#' @param DestinationDomainInfo &#91;required&#93; Specifies the `DomainInformation` for the destination Elasticsearch
#' domain.
#' @param ConnectionAlias &#91;required&#93; Specifies the connection alias that will be used by the customer for
#' this connection.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_creat_outbo_cross_clust_searc_conne
elasticsearchservice_create_outbound_cross_cluster_search_connection <- function(SourceDomainInfo, DestinationDomainInfo, ConnectionAlias) {
  op <- new_operation(
    name = "CreateOutboundCrossClusterSearchConnection",
    http_method = "POST",
    http_path = "/2015-01-01/es/ccs/outboundConnection",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$create_outbound_cross_cluster_search_connection_input(SourceDomainInfo = SourceDomainInfo, DestinationDomainInfo = DestinationDomainInfo, ConnectionAlias = ConnectionAlias)
  output <- .elasticsearchservice$create_outbound_cross_cluster_search_connection_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$create_outbound_cross_cluster_search_connection <- elasticsearchservice_create_outbound_cross_cluster_search_connection

#' Create a package for use with Amazon ES domains
#'
#' @description
#' Create a package for use with Amazon ES domains.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_create_package/](https://www.paws-r-sdk.com/docs/elasticsearchservice_create_package/) for full documentation.
#'
#' @param PackageName &#91;required&#93; Unique identifier for the package.
#' @param PackageType &#91;required&#93; Type of package. Currently supports only TXT-DICTIONARY.
#' @param PackageDescription Description of the package.
#' @param PackageSource &#91;required&#93; The customer S3 location `PackageSource` for importing the package.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_create_package
elasticsearchservice_create_package <- function(PackageName, PackageType, PackageDescription = NULL, PackageSource) {
  op <- new_operation(
    name = "CreatePackage",
    http_method = "POST",
    http_path = "/2015-01-01/packages",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$create_package_input(PackageName = PackageName, PackageType = PackageType, PackageDescription = PackageDescription, PackageSource = PackageSource)
  output <- .elasticsearchservice$create_package_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$create_package <- elasticsearchservice_create_package

#' Creates an Amazon OpenSearch Service-managed VPC endpoint
#'
#' @description
#' Creates an Amazon OpenSearch Service-managed VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_create_vpc_endpoint/](https://www.paws-r-sdk.com/docs/elasticsearchservice_create_vpc_endpoint/) for full documentation.
#'
#' @param DomainArn &#91;required&#93; The Amazon Resource Name (ARN) of the domain to grant access to.
#' @param VpcOptions &#91;required&#93; Options to specify the subnets and security groups for the endpoint.
#' @param ClientToken Unique, case-sensitive identifier to ensure idempotency of the request.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_create_vpc_endpoint
elasticsearchservice_create_vpc_endpoint <- function(DomainArn, VpcOptions, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateVpcEndpoint",
    http_method = "POST",
    http_path = "/2015-01-01/es/vpcEndpoints",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$create_vpc_endpoint_input(DomainArn = DomainArn, VpcOptions = VpcOptions, ClientToken = ClientToken)
  output <- .elasticsearchservice$create_vpc_endpoint_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$create_vpc_endpoint <- elasticsearchservice_create_vpc_endpoint

#' Permanently deletes the specified Elasticsearch domain and all of its
#' data
#'
#' @description
#' Permanently deletes the specified Elasticsearch domain and all of its data. Once a domain is deleted, it cannot be recovered.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_elasticsearch_domain/](https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_elasticsearch_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the Elasticsearch domain that you want to permanently
#' delete.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_delete_elasticsearch_domain
elasticsearchservice_delete_elasticsearch_domain <- function(DomainName) {
  op <- new_operation(
    name = "DeleteElasticsearchDomain",
    http_method = "DELETE",
    http_path = "/2015-01-01/es/domain/{DomainName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$delete_elasticsearch_domain_input(DomainName = DomainName)
  output <- .elasticsearchservice$delete_elasticsearch_domain_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$delete_elasticsearch_domain <- elasticsearchservice_delete_elasticsearch_domain

#' Deletes the service-linked role that Elasticsearch Service uses to
#' manage and maintain VPC domains
#'
#' @description
#' Deletes the service-linked role that Elasticsearch Service uses to manage and maintain VPC domains. Role deletion will fail if any existing VPC domains use the role. You must delete any such Elasticsearch domains before deleting the role. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html#es-enabling-slr" target="_blank">Deleting Elasticsearch Service Role</a> in *VPC Endpoints for Amazon Elasticsearch Service Domains*.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_elasticsearch_service_role/](https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_elasticsearch_service_role/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_delete_elasticsearch_service_role
elasticsearchservice_delete_elasticsearch_service_role <- function() {
  op <- new_operation(
    name = "DeleteElasticsearchServiceRole",
    http_method = "DELETE",
    http_path = "/2015-01-01/es/role",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$delete_elasticsearch_service_role_input()
  output <- .elasticsearchservice$delete_elasticsearch_service_role_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$delete_elasticsearch_service_role <- elasticsearchservice_delete_elasticsearch_service_role

#' Allows the destination domain owner to delete an existing inbound
#' cross-cluster search connection
#'
#' @description
#' Allows the destination domain owner to delete an existing inbound cross-cluster search connection.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_inbound_cross_cluster_search_connection/](https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_inbound_cross_cluster_search_connection/) for full documentation.
#'
#' @param CrossClusterSearchConnectionId &#91;required&#93; The id of the inbound connection that you want to permanently delete.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_delet_inbou_cross_clust_searc_conne
elasticsearchservice_delete_inbound_cross_cluster_search_connection <- function(CrossClusterSearchConnectionId) {
  op <- new_operation(
    name = "DeleteInboundCrossClusterSearchConnection",
    http_method = "DELETE",
    http_path = "/2015-01-01/es/ccs/inboundConnection/{ConnectionId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$delete_inbound_cross_cluster_search_connection_input(CrossClusterSearchConnectionId = CrossClusterSearchConnectionId)
  output <- .elasticsearchservice$delete_inbound_cross_cluster_search_connection_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$delete_inbound_cross_cluster_search_connection <- elasticsearchservice_delete_inbound_cross_cluster_search_connection

#' Allows the source domain owner to delete an existing outbound
#' cross-cluster search connection
#'
#' @description
#' Allows the source domain owner to delete an existing outbound cross-cluster search connection.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_outbound_cross_cluster_search_connection/](https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_outbound_cross_cluster_search_connection/) for full documentation.
#'
#' @param CrossClusterSearchConnectionId &#91;required&#93; The id of the outbound connection that you want to permanently delete.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_delet_outbo_cross_clust_searc_conne
elasticsearchservice_delete_outbound_cross_cluster_search_connection <- function(CrossClusterSearchConnectionId) {
  op <- new_operation(
    name = "DeleteOutboundCrossClusterSearchConnection",
    http_method = "DELETE",
    http_path = "/2015-01-01/es/ccs/outboundConnection/{ConnectionId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$delete_outbound_cross_cluster_search_connection_input(CrossClusterSearchConnectionId = CrossClusterSearchConnectionId)
  output <- .elasticsearchservice$delete_outbound_cross_cluster_search_connection_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$delete_outbound_cross_cluster_search_connection <- elasticsearchservice_delete_outbound_cross_cluster_search_connection

#' Delete the package
#'
#' @description
#' Delete the package.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_package/](https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_package/) for full documentation.
#'
#' @param PackageID &#91;required&#93; Internal ID of the package that you want to delete. Use
#' [`describe_packages`][elasticsearchservice_describe_packages] to find
#' this value.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_delete_package
elasticsearchservice_delete_package <- function(PackageID) {
  op <- new_operation(
    name = "DeletePackage",
    http_method = "DELETE",
    http_path = "/2015-01-01/packages/{PackageID}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$delete_package_input(PackageID = PackageID)
  output <- .elasticsearchservice$delete_package_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$delete_package <- elasticsearchservice_delete_package

#' Deletes an Amazon OpenSearch Service-managed interface VPC endpoint
#'
#' @description
#' Deletes an Amazon OpenSearch Service-managed interface VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_vpc_endpoint/](https://www.paws-r-sdk.com/docs/elasticsearchservice_delete_vpc_endpoint/) for full documentation.
#'
#' @param VpcEndpointId &#91;required&#93; The unique identifier of the endpoint to be deleted.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_delete_vpc_endpoint
elasticsearchservice_delete_vpc_endpoint <- function(VpcEndpointId) {
  op <- new_operation(
    name = "DeleteVpcEndpoint",
    http_method = "DELETE",
    http_path = "/2015-01-01/es/vpcEndpoints/{VpcEndpointId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$delete_vpc_endpoint_input(VpcEndpointId = VpcEndpointId)
  output <- .elasticsearchservice$delete_vpc_endpoint_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$delete_vpc_endpoint <- elasticsearchservice_delete_vpc_endpoint

#' Provides scheduled Auto-Tune action details for the Elasticsearch
#' domain, such as Auto-Tune action type, description, severity, and
#' scheduled date
#'
#' @description
#' Provides scheduled Auto-Tune action details for the Elasticsearch domain, such as Auto-Tune action type, description, severity, and scheduled date.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_domain_auto_tunes/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_domain_auto_tunes/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Specifies the domain name for which you want Auto-Tune action details.
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken NextToken is sent in case the earlier API call results contain the
#' NextToken. It is used for pagination.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_domain_auto_tunes
elasticsearchservice_describe_domain_auto_tunes <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeDomainAutoTunes",
    http_method = "GET",
    http_path = "/2015-01-01/es/domain/{DomainName}/autoTunes",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_domain_auto_tunes_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$describe_domain_auto_tunes_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_domain_auto_tunes <- elasticsearchservice_describe_domain_auto_tunes

#' Returns information about the current blue/green deployment happening on
#' a domain, including a change ID, status, and progress stages
#'
#' @description
#' Returns information about the current blue/green deployment happening on a domain, including a change ID, status, and progress stages.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_domain_change_progress/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_domain_change_progress/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The domain you want to get the progress information about.
#' @param ChangeId The specific change ID for which you want to get progress information.
#' This is an optional parameter. If omitted, the service returns
#' information about the most recent configuration change.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_domain_change_progress
elasticsearchservice_describe_domain_change_progress <- function(DomainName, ChangeId = NULL) {
  op <- new_operation(
    name = "DescribeDomainChangeProgress",
    http_method = "GET",
    http_path = "/2015-01-01/es/domain/{DomainName}/progress",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_domain_change_progress_input(DomainName = DomainName, ChangeId = ChangeId)
  output <- .elasticsearchservice$describe_domain_change_progress_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_domain_change_progress <- elasticsearchservice_describe_domain_change_progress

#' Returns domain configuration information about the specified
#' Elasticsearch domain, including the domain ID, domain endpoint, and
#' domain ARN
#'
#' @description
#' Returns domain configuration information about the specified Elasticsearch domain, including the domain ID, domain endpoint, and domain ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_elasticsearch_domain/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_elasticsearch_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the Elasticsearch domain for which you want information.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_elasticsearch_domain
elasticsearchservice_describe_elasticsearch_domain <- function(DomainName) {
  op <- new_operation(
    name = "DescribeElasticsearchDomain",
    http_method = "GET",
    http_path = "/2015-01-01/es/domain/{DomainName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_elasticsearch_domain_input(DomainName = DomainName)
  output <- .elasticsearchservice$describe_elasticsearch_domain_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_elasticsearch_domain <- elasticsearchservice_describe_elasticsearch_domain

#' Provides cluster configuration information about the specified
#' Elasticsearch domain, such as the state, creation date, update version,
#' and update date for cluster options
#'
#' @description
#' Provides cluster configuration information about the specified Elasticsearch domain, such as the state, creation date, update version, and update date for cluster options.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_elasticsearch_domain_config/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_elasticsearch_domain_config/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The Elasticsearch domain that you want to get information about.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_elasticsearch_domain_config
elasticsearchservice_describe_elasticsearch_domain_config <- function(DomainName) {
  op <- new_operation(
    name = "DescribeElasticsearchDomainConfig",
    http_method = "GET",
    http_path = "/2015-01-01/es/domain/{DomainName}/config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_elasticsearch_domain_config_input(DomainName = DomainName)
  output <- .elasticsearchservice$describe_elasticsearch_domain_config_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_elasticsearch_domain_config <- elasticsearchservice_describe_elasticsearch_domain_config

#' Returns domain configuration information about the specified
#' Elasticsearch domains, including the domain ID, domain endpoint, and
#' domain ARN
#'
#' @description
#' Returns domain configuration information about the specified Elasticsearch domains, including the domain ID, domain endpoint, and domain ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_elasticsearch_domains/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_elasticsearch_domains/) for full documentation.
#'
#' @param DomainNames &#91;required&#93; The Elasticsearch domains for which you want information.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_elasticsearch_domains
elasticsearchservice_describe_elasticsearch_domains <- function(DomainNames) {
  op <- new_operation(
    name = "DescribeElasticsearchDomains",
    http_method = "POST",
    http_path = "/2015-01-01/es/domain-info",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_elasticsearch_domains_input(DomainNames = DomainNames)
  output <- .elasticsearchservice$describe_elasticsearch_domains_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_elasticsearch_domains <- elasticsearchservice_describe_elasticsearch_domains

#' Describe Elasticsearch Limits for a given InstanceType and
#' ElasticsearchVersion
#'
#' @description
#' Describe Elasticsearch Limits for a given InstanceType and ElasticsearchVersion. When modifying existing Domain, specify the ` DomainName ` to know what Limits are supported for modifying.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_elasticsearch_instance_type_limits/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_elasticsearch_instance_type_limits/) for full documentation.
#'
#' @param DomainName DomainName represents the name of the Domain that we are trying to
#' modify. This should be present only if we are querying for Elasticsearch
#' ` Limits ` for existing domain.
#' @param InstanceType &#91;required&#93; The instance type for an Elasticsearch cluster for which Elasticsearch
#' ` Limits ` are needed.
#' @param ElasticsearchVersion &#91;required&#93; Version of Elasticsearch for which ` Limits ` are needed.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_descr_elast_insta_type_limit
elasticsearchservice_describe_elasticsearch_instance_type_limits <- function(DomainName = NULL, InstanceType, ElasticsearchVersion) {
  op <- new_operation(
    name = "DescribeElasticsearchInstanceTypeLimits",
    http_method = "GET",
    http_path = "/2015-01-01/es/instanceTypeLimits/{ElasticsearchVersion}/{InstanceType}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_elasticsearch_instance_type_limits_input(DomainName = DomainName, InstanceType = InstanceType, ElasticsearchVersion = ElasticsearchVersion)
  output <- .elasticsearchservice$describe_elasticsearch_instance_type_limits_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_elasticsearch_instance_type_limits <- elasticsearchservice_describe_elasticsearch_instance_type_limits

#' Lists all the inbound cross-cluster search connections for a destination
#' domain
#'
#' @description
#' Lists all the inbound cross-cluster search connections for a destination domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_inbound_cross_cluster_search_connections/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_inbound_cross_cluster_search_connections/) for full documentation.
#'
#' @param Filters A list of filters used to match properties for inbound cross-cluster
#' search connection. Available `Filter` names for this operation are:
#' 
#' -   cross-cluster-search-connection-id
#' -   source-domain-info.domain-name
#' -   source-domain-info.owner-id
#' -   source-domain-info.region
#' -   destination-domain-info.domain-name
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken NextToken is sent in case the earlier API call results contain the
#' NextToken. It is used for pagination.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_descr_inbou_cross_clust_searc_conne
elasticsearchservice_describe_inbound_cross_cluster_search_connections <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInboundCrossClusterSearchConnections",
    http_method = "POST",
    http_path = "/2015-01-01/es/ccs/inboundConnection/search",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_inbound_cross_cluster_search_connections_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$describe_inbound_cross_cluster_search_connections_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_inbound_cross_cluster_search_connections <- elasticsearchservice_describe_inbound_cross_cluster_search_connections

#' Lists all the outbound cross-cluster search connections for a source
#' domain
#'
#' @description
#' Lists all the outbound cross-cluster search connections for a source domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_outbound_cross_cluster_search_connections/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_outbound_cross_cluster_search_connections/) for full documentation.
#'
#' @param Filters A list of filters used to match properties for outbound cross-cluster
#' search connection. Available `Filter` names for this operation are:
#' 
#' -   cross-cluster-search-connection-id
#' -   destination-domain-info.domain-name
#' -   destination-domain-info.owner-id
#' -   destination-domain-info.region
#' -   source-domain-info.domain-name
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken NextToken is sent in case the earlier API call results contain the
#' NextToken. It is used for pagination.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_descr_outbo_cross_clust_searc_conne
elasticsearchservice_describe_outbound_cross_cluster_search_connections <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOutboundCrossClusterSearchConnections",
    http_method = "POST",
    http_path = "/2015-01-01/es/ccs/outboundConnection/search",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_outbound_cross_cluster_search_connections_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$describe_outbound_cross_cluster_search_connections_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_outbound_cross_cluster_search_connections <- elasticsearchservice_describe_outbound_cross_cluster_search_connections

#' Describes all packages available to Amazon ES
#'
#' @description
#' Describes all packages available to Amazon ES. Includes options for filtering, limiting the number of results, and pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_packages/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_packages/) for full documentation.
#'
#' @param Filters Only returns packages that match the `DescribePackagesFilterList`
#' values.
#' @param MaxResults Limits results to a maximum number of packages.
#' @param NextToken Used for pagination. Only necessary if a previous API call includes a
#' non-null NextToken value. If provided, returns results for the next
#' page.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_packages
elasticsearchservice_describe_packages <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePackages",
    http_method = "POST",
    http_path = "/2015-01-01/packages/describe",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_packages_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$describe_packages_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_packages <- elasticsearchservice_describe_packages

#' Lists available reserved Elasticsearch instance offerings
#'
#' @description
#' Lists available reserved Elasticsearch instance offerings.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_reserved_elasticsearch_instance_offerings/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_reserved_elasticsearch_instance_offerings/) for full documentation.
#'
#' @param ReservedElasticsearchInstanceOfferingId The offering identifier filter value. Use this parameter to show only
#' the available offering that matches the specified reservation
#' identifier.
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken NextToken should be sent in case if earlier API call produced result
#' containing NextToken. It is used for pagination.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_descr_reser_elast_insta_offer
elasticsearchservice_describe_reserved_elasticsearch_instance_offerings <- function(ReservedElasticsearchInstanceOfferingId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedElasticsearchInstanceOfferings",
    http_method = "GET",
    http_path = "/2015-01-01/es/reservedInstanceOfferings",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ReservedElasticsearchInstanceOfferings"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_reserved_elasticsearch_instance_offerings_input(ReservedElasticsearchInstanceOfferingId = ReservedElasticsearchInstanceOfferingId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$describe_reserved_elasticsearch_instance_offerings_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_reserved_elasticsearch_instance_offerings <- elasticsearchservice_describe_reserved_elasticsearch_instance_offerings

#' Returns information about reserved Elasticsearch instances for this
#' account
#'
#' @description
#' Returns information about reserved Elasticsearch instances for this account.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_reserved_elasticsearch_instances/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_reserved_elasticsearch_instances/) for full documentation.
#'
#' @param ReservedElasticsearchInstanceId The reserved instance identifier filter value. Use this parameter to
#' show only the reservation that matches the specified reserved
#' Elasticsearch instance ID.
#' @param MaxResults Set this value to limit the number of results returned. If not
#' specified, defaults to 100.
#' @param NextToken NextToken should be sent in case if earlier API call produced result
#' containing NextToken. It is used for pagination.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_descri_reserv_elasti_instan
elasticsearchservice_describe_reserved_elasticsearch_instances <- function(ReservedElasticsearchInstanceId = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedElasticsearchInstances",
    http_method = "GET",
    http_path = "/2015-01-01/es/reservedInstances",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ReservedElasticsearchInstances"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_reserved_elasticsearch_instances_input(ReservedElasticsearchInstanceId = ReservedElasticsearchInstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$describe_reserved_elasticsearch_instances_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_reserved_elasticsearch_instances <- elasticsearchservice_describe_reserved_elasticsearch_instances

#' Describes one or more Amazon OpenSearch Service-managed VPC endpoints
#'
#' @description
#' Describes one or more Amazon OpenSearch Service-managed VPC endpoints.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_vpc_endpoints/](https://www.paws-r-sdk.com/docs/elasticsearchservice_describe_vpc_endpoints/) for full documentation.
#'
#' @param VpcEndpointIds &#91;required&#93; The unique identifiers of the endpoints to get information about.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_describe_vpc_endpoints
elasticsearchservice_describe_vpc_endpoints <- function(VpcEndpointIds) {
  op <- new_operation(
    name = "DescribeVpcEndpoints",
    http_method = "POST",
    http_path = "/2015-01-01/es/vpcEndpoints/describe",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$describe_vpc_endpoints_input(VpcEndpointIds = VpcEndpointIds)
  output <- .elasticsearchservice$describe_vpc_endpoints_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$describe_vpc_endpoints <- elasticsearchservice_describe_vpc_endpoints

#' Dissociates a package from the Amazon ES domain
#'
#' @description
#' Dissociates a package from the Amazon ES domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_dissociate_package/](https://www.paws-r-sdk.com/docs/elasticsearchservice_dissociate_package/) for full documentation.
#'
#' @param PackageID &#91;required&#93; Internal ID of the package that you want to associate with a domain. Use
#' [`describe_packages`][elasticsearchservice_describe_packages] to find
#' this value.
#' @param DomainName &#91;required&#93; Name of the domain that you want to associate the package with.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_dissociate_package
elasticsearchservice_dissociate_package <- function(PackageID, DomainName) {
  op <- new_operation(
    name = "DissociatePackage",
    http_method = "POST",
    http_path = "/2015-01-01/packages/dissociate/{PackageID}/{DomainName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$dissociate_package_input(PackageID = PackageID, DomainName = DomainName)
  output <- .elasticsearchservice$dissociate_package_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$dissociate_package <- elasticsearchservice_dissociate_package

#' Returns a list of upgrade compatible Elastisearch versions
#'
#' @description
#' Returns a list of upgrade compatible Elastisearch versions. You can optionally pass a ` DomainName ` to get all upgrade compatible Elasticsearch versions for that specific domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_get_compatible_elasticsearch_versions/](https://www.paws-r-sdk.com/docs/elasticsearchservice_get_compatible_elasticsearch_versions/) for full documentation.
#'
#' @param DomainName 
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_get_compatible_elasticsearch_versions
elasticsearchservice_get_compatible_elasticsearch_versions <- function(DomainName = NULL) {
  op <- new_operation(
    name = "GetCompatibleElasticsearchVersions",
    http_method = "GET",
    http_path = "/2015-01-01/es/compatibleVersions",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$get_compatible_elasticsearch_versions_input(DomainName = DomainName)
  output <- .elasticsearchservice$get_compatible_elasticsearch_versions_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$get_compatible_elasticsearch_versions <- elasticsearchservice_get_compatible_elasticsearch_versions

#' Returns a list of versions of the package, along with their creation
#' time and commit message
#'
#' @description
#' Returns a list of versions of the package, along with their creation time and commit message.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_get_package_version_history/](https://www.paws-r-sdk.com/docs/elasticsearchservice_get_package_version_history/) for full documentation.
#'
#' @param PackageID &#91;required&#93; Returns an audit history of versions of the package.
#' @param MaxResults Limits results to a maximum number of versions.
#' @param NextToken Used for pagination. Only necessary if a previous API call includes a
#' non-null NextToken value. If provided, returns results for the next
#' page.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_get_package_version_history
elasticsearchservice_get_package_version_history <- function(PackageID, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetPackageVersionHistory",
    http_method = "GET",
    http_path = "/2015-01-01/packages/{PackageID}/history",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$get_package_version_history_input(PackageID = PackageID, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$get_package_version_history_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$get_package_version_history <- elasticsearchservice_get_package_version_history

#' Retrieves the complete history of the last 10 upgrades that were
#' performed on the domain
#'
#' @description
#' Retrieves the complete history of the last 10 upgrades that were performed on the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_get_upgrade_history/](https://www.paws-r-sdk.com/docs/elasticsearchservice_get_upgrade_history/) for full documentation.
#'
#' @param DomainName &#91;required&#93; 
#' @param MaxResults 
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_get_upgrade_history
elasticsearchservice_get_upgrade_history <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetUpgradeHistory",
    http_method = "GET",
    http_path = "/2015-01-01/es/upgradeDomain/{DomainName}/history",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "UpgradeHistories"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$get_upgrade_history_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$get_upgrade_history_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$get_upgrade_history <- elasticsearchservice_get_upgrade_history

#' Retrieves the latest status of the last upgrade or upgrade eligibility
#' check that was performed on the domain
#'
#' @description
#' Retrieves the latest status of the last upgrade or upgrade eligibility check that was performed on the domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_get_upgrade_status/](https://www.paws-r-sdk.com/docs/elasticsearchservice_get_upgrade_status/) for full documentation.
#'
#' @param DomainName &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_get_upgrade_status
elasticsearchservice_get_upgrade_status <- function(DomainName) {
  op <- new_operation(
    name = "GetUpgradeStatus",
    http_method = "GET",
    http_path = "/2015-01-01/es/upgradeDomain/{DomainName}/status",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$get_upgrade_status_input(DomainName = DomainName)
  output <- .elasticsearchservice$get_upgrade_status_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$get_upgrade_status <- elasticsearchservice_get_upgrade_status

#' Returns the name of all Elasticsearch domains owned by the current
#' user's account
#'
#' @description
#' Returns the name of all Elasticsearch domains owned by the current user's account.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_list_domain_names/](https://www.paws-r-sdk.com/docs/elasticsearchservice_list_domain_names/) for full documentation.
#'
#' @param EngineType Optional parameter to filter the output by domain engine type.
#' Acceptable values are 'Elasticsearch' and 'OpenSearch'.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_domain_names
elasticsearchservice_list_domain_names <- function(EngineType = NULL) {
  op <- new_operation(
    name = "ListDomainNames",
    http_method = "GET",
    http_path = "/2015-01-01/domain",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$list_domain_names_input(EngineType = EngineType)
  output <- .elasticsearchservice$list_domain_names_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_domain_names <- elasticsearchservice_list_domain_names

#' Lists all Amazon ES domains associated with the package
#'
#' @description
#' Lists all Amazon ES domains associated with the package.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_list_domains_for_package/](https://www.paws-r-sdk.com/docs/elasticsearchservice_list_domains_for_package/) for full documentation.
#'
#' @param PackageID &#91;required&#93; The package for which to list domains.
#' @param MaxResults Limits results to a maximum number of domains.
#' @param NextToken Used for pagination. Only necessary if a previous API call includes a
#' non-null NextToken value. If provided, returns results for the next
#' page.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_domains_for_package
elasticsearchservice_list_domains_for_package <- function(PackageID, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDomainsForPackage",
    http_method = "GET",
    http_path = "/2015-01-01/packages/{PackageID}/domains",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$list_domains_for_package_input(PackageID = PackageID, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$list_domains_for_package_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_domains_for_package <- elasticsearchservice_list_domains_for_package

#' List all Elasticsearch instance types that are supported for given
#' ElasticsearchVersion
#'
#' @description
#' List all Elasticsearch instance types that are supported for given ElasticsearchVersion
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_list_elasticsearch_instance_types/](https://www.paws-r-sdk.com/docs/elasticsearchservice_list_elasticsearch_instance_types/) for full documentation.
#'
#' @param ElasticsearchVersion &#91;required&#93; Version of Elasticsearch for which list of supported elasticsearch
#' instance types are needed.
#' @param DomainName DomainName represents the name of the Domain that we are trying to
#' modify. This should be present only if we are querying for list of
#' available Elasticsearch instance types when modifying existing domain.
#' @param MaxResults Set this value to limit the number of results returned. Value provided
#' must be greater than 30 else it wont be honored.
#' @param NextToken NextToken should be sent in case if earlier API call produced result
#' containing NextToken. It is used for pagination.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_elasticsearch_instance_types
elasticsearchservice_list_elasticsearch_instance_types <- function(ElasticsearchVersion, DomainName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListElasticsearchInstanceTypes",
    http_method = "GET",
    http_path = "/2015-01-01/es/instanceTypes/{ElasticsearchVersion}",
    host_prefix = "",
    paginator = list(result_key = "ElasticsearchInstanceTypes", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$list_elasticsearch_instance_types_input(ElasticsearchVersion = ElasticsearchVersion, DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$list_elasticsearch_instance_types_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_elasticsearch_instance_types <- elasticsearchservice_list_elasticsearch_instance_types

#' List all supported Elasticsearch versions
#'
#' @description
#' List all supported Elasticsearch versions
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_list_elasticsearch_versions/](https://www.paws-r-sdk.com/docs/elasticsearchservice_list_elasticsearch_versions/) for full documentation.
#'
#' @param MaxResults Set this value to limit the number of results returned. Value provided
#' must be greater than 10 else it wont be honored.
#' @param NextToken 
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_elasticsearch_versions
elasticsearchservice_list_elasticsearch_versions <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListElasticsearchVersions",
    http_method = "GET",
    http_path = "/2015-01-01/es/versions",
    host_prefix = "",
    paginator = list(result_key = "ElasticsearchVersions", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$list_elasticsearch_versions_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$list_elasticsearch_versions_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_elasticsearch_versions <- elasticsearchservice_list_elasticsearch_versions

#' Lists all packages associated with the Amazon ES domain
#'
#' @description
#' Lists all packages associated with the Amazon ES domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_list_packages_for_domain/](https://www.paws-r-sdk.com/docs/elasticsearchservice_list_packages_for_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain for which you want to list associated packages.
#' @param MaxResults Limits results to a maximum number of packages.
#' @param NextToken Used for pagination. Only necessary if a previous API call includes a
#' non-null NextToken value. If provided, returns results for the next
#' page.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_packages_for_domain
elasticsearchservice_list_packages_for_domain <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPackagesForDomain",
    http_method = "GET",
    http_path = "/2015-01-01/domain/{DomainName}/packages",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$list_packages_for_domain_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .elasticsearchservice$list_packages_for_domain_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_packages_for_domain <- elasticsearchservice_list_packages_for_domain

#' Returns all tags for the given Elasticsearch domain
#'
#' @description
#' Returns all tags for the given Elasticsearch domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_list_tags/](https://www.paws-r-sdk.com/docs/elasticsearchservice_list_tags/) for full documentation.
#'
#' @param ARN &#91;required&#93; Specify the `ARN` for the Elasticsearch domain to which the tags are
#' attached that you want to view.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_tags
elasticsearchservice_list_tags <- function(ARN) {
  op <- new_operation(
    name = "ListTags",
    http_method = "GET",
    http_path = "/2015-01-01/tags/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$list_tags_input(ARN = ARN)
  output <- .elasticsearchservice$list_tags_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_tags <- elasticsearchservice_list_tags

#' Retrieves information about each principal that is allowed to access a
#' given Amazon OpenSearch Service domain through the use of an interface
#' VPC endpoint
#'
#' @description
#' Retrieves information about each principal that is allowed to access a given Amazon OpenSearch Service domain through the use of an interface VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_list_vpc_endpoint_access/](https://www.paws-r-sdk.com/docs/elasticsearchservice_list_vpc_endpoint_access/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the OpenSearch Service domain to retrieve access information
#' for.
#' @param NextToken Provides an identifier to allow retrieval of paginated results.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_vpc_endpoint_access
elasticsearchservice_list_vpc_endpoint_access <- function(DomainName, NextToken = NULL) {
  op <- new_operation(
    name = "ListVpcEndpointAccess",
    http_method = "GET",
    http_path = "/2015-01-01/es/domain/{DomainName}/listVpcEndpointAccess",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$list_vpc_endpoint_access_input(DomainName = DomainName, NextToken = NextToken)
  output <- .elasticsearchservice$list_vpc_endpoint_access_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_vpc_endpoint_access <- elasticsearchservice_list_vpc_endpoint_access

#' Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the
#' current account and Region
#'
#' @description
#' Retrieves all Amazon OpenSearch Service-managed VPC endpoints in the current account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_list_vpc_endpoints/](https://www.paws-r-sdk.com/docs/elasticsearchservice_list_vpc_endpoints/) for full documentation.
#'
#' @param NextToken Identifier to allow retrieval of paginated results.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_vpc_endpoints
elasticsearchservice_list_vpc_endpoints <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListVpcEndpoints",
    http_method = "GET",
    http_path = "/2015-01-01/es/vpcEndpoints",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$list_vpc_endpoints_input(NextToken = NextToken)
  output <- .elasticsearchservice$list_vpc_endpoints_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_vpc_endpoints <- elasticsearchservice_list_vpc_endpoints

#' Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated
#' with a particular domain
#'
#' @description
#' Retrieves all Amazon OpenSearch Service-managed VPC endpoints associated with a particular domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_list_vpc_endpoints_for_domain/](https://www.paws-r-sdk.com/docs/elasticsearchservice_list_vpc_endpoints_for_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; Name of the ElasticSearch domain whose VPC endpoints are to be listed.
#' @param NextToken Provides an identifier to allow retrieval of paginated results.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_list_vpc_endpoints_for_domain
elasticsearchservice_list_vpc_endpoints_for_domain <- function(DomainName, NextToken = NULL) {
  op <- new_operation(
    name = "ListVpcEndpointsForDomain",
    http_method = "GET",
    http_path = "/2015-01-01/es/domain/{DomainName}/vpcEndpoints",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$list_vpc_endpoints_for_domain_input(DomainName = DomainName, NextToken = NextToken)
  output <- .elasticsearchservice$list_vpc_endpoints_for_domain_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$list_vpc_endpoints_for_domain <- elasticsearchservice_list_vpc_endpoints_for_domain

#' Allows you to purchase reserved Elasticsearch instances
#'
#' @description
#' Allows you to purchase reserved Elasticsearch instances.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_purchase_reserved_elasticsearch_instance_offering/](https://www.paws-r-sdk.com/docs/elasticsearchservice_purchase_reserved_elasticsearch_instance_offering/) for full documentation.
#'
#' @param ReservedElasticsearchInstanceOfferingId &#91;required&#93; The ID of the reserved Elasticsearch instance offering to purchase.
#' @param ReservationName &#91;required&#93; A customer-specified identifier to track this reservation.
#' @param InstanceCount The number of Elasticsearch instances to reserve.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_purch_reser_elast_insta_offer
elasticsearchservice_purchase_reserved_elasticsearch_instance_offering <- function(ReservedElasticsearchInstanceOfferingId, ReservationName, InstanceCount = NULL) {
  op <- new_operation(
    name = "PurchaseReservedElasticsearchInstanceOffering",
    http_method = "POST",
    http_path = "/2015-01-01/es/purchaseReservedInstanceOffering",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$purchase_reserved_elasticsearch_instance_offering_input(ReservedElasticsearchInstanceOfferingId = ReservedElasticsearchInstanceOfferingId, ReservationName = ReservationName, InstanceCount = InstanceCount)
  output <- .elasticsearchservice$purchase_reserved_elasticsearch_instance_offering_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$purchase_reserved_elasticsearch_instance_offering <- elasticsearchservice_purchase_reserved_elasticsearch_instance_offering

#' Allows the destination domain owner to reject an inbound cross-cluster
#' search connection request
#'
#' @description
#' Allows the destination domain owner to reject an inbound cross-cluster search connection request.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_reject_inbound_cross_cluster_search_connection/](https://www.paws-r-sdk.com/docs/elasticsearchservice_reject_inbound_cross_cluster_search_connection/) for full documentation.
#'
#' @param CrossClusterSearchConnectionId &#91;required&#93; The id of the inbound connection that you want to reject.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_rejec_inbou_cross_clust_searc_conne
elasticsearchservice_reject_inbound_cross_cluster_search_connection <- function(CrossClusterSearchConnectionId) {
  op <- new_operation(
    name = "RejectInboundCrossClusterSearchConnection",
    http_method = "PUT",
    http_path = "/2015-01-01/es/ccs/inboundConnection/{ConnectionId}/reject",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$reject_inbound_cross_cluster_search_connection_input(CrossClusterSearchConnectionId = CrossClusterSearchConnectionId)
  output <- .elasticsearchservice$reject_inbound_cross_cluster_search_connection_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$reject_inbound_cross_cluster_search_connection <- elasticsearchservice_reject_inbound_cross_cluster_search_connection

#' Removes the specified set of tags from the specified Elasticsearch
#' domain
#'
#' @description
#' Removes the specified set of tags from the specified Elasticsearch domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_remove_tags/](https://www.paws-r-sdk.com/docs/elasticsearchservice_remove_tags/) for full documentation.
#'
#' @param ARN &#91;required&#93; Specifies the `ARN` for the Elasticsearch domain from which you want to
#' delete the specified tags.
#' @param TagKeys &#91;required&#93; Specifies the `TagKey` list which you want to remove from the
#' Elasticsearch domain.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_remove_tags
elasticsearchservice_remove_tags <- function(ARN, TagKeys) {
  op <- new_operation(
    name = "RemoveTags",
    http_method = "POST",
    http_path = "/2015-01-01/tags-removal",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$remove_tags_input(ARN = ARN, TagKeys = TagKeys)
  output <- .elasticsearchservice$remove_tags_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$remove_tags <- elasticsearchservice_remove_tags

#' Revokes access to an Amazon OpenSearch Service domain that was provided
#' through an interface VPC endpoint
#'
#' @description
#' Revokes access to an Amazon OpenSearch Service domain that was provided through an interface VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_revoke_vpc_endpoint_access/](https://www.paws-r-sdk.com/docs/elasticsearchservice_revoke_vpc_endpoint_access/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the OpenSearch Service domain.
#' @param Account &#91;required&#93; The account ID to revoke access from.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_revoke_vpc_endpoint_access
elasticsearchservice_revoke_vpc_endpoint_access <- function(DomainName, Account) {
  op <- new_operation(
    name = "RevokeVpcEndpointAccess",
    http_method = "POST",
    http_path = "/2015-01-01/es/domain/{DomainName}/revokeVpcEndpointAccess",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$revoke_vpc_endpoint_access_input(DomainName = DomainName, Account = Account)
  output <- .elasticsearchservice$revoke_vpc_endpoint_access_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$revoke_vpc_endpoint_access <- elasticsearchservice_revoke_vpc_endpoint_access

#' Schedules a service software update for an Amazon ES domain
#'
#' @description
#' Schedules a service software update for an Amazon ES domain.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_start_elasticsearch_service_software_update/](https://www.paws-r-sdk.com/docs/elasticsearchservice_start_elasticsearch_service_software_update/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the domain that you want to update to the latest service
#' software.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_start_elast_servi_softw_updat
elasticsearchservice_start_elasticsearch_service_software_update <- function(DomainName) {
  op <- new_operation(
    name = "StartElasticsearchServiceSoftwareUpdate",
    http_method = "POST",
    http_path = "/2015-01-01/es/serviceSoftwareUpdate/start",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$start_elasticsearch_service_software_update_input(DomainName = DomainName)
  output <- .elasticsearchservice$start_elasticsearch_service_software_update_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$start_elasticsearch_service_software_update <- elasticsearchservice_start_elasticsearch_service_software_update

#' Modifies the cluster configuration of the specified Elasticsearch
#' domain, setting as setting the instance type and the number of instances
#'
#' @description
#' Modifies the cluster configuration of the specified Elasticsearch domain, setting as setting the instance type and the number of instances.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_update_elasticsearch_domain_config/](https://www.paws-r-sdk.com/docs/elasticsearchservice_update_elasticsearch_domain_config/) for full documentation.
#'
#' @param DomainName &#91;required&#93; The name of the Elasticsearch domain that you are updating.
#' @param ElasticsearchClusterConfig The type and number of instances to instantiate for the domain cluster.
#' @param EBSOptions Specify the type and size of the EBS volume that you want to use.
#' @param SnapshotOptions Option to set the time, in UTC format, for the daily automated snapshot.
#' Default value is `0` hours.
#' @param VPCOptions Options to specify the subnets and security groups for VPC endpoint. For
#' more information, see <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html#es-creating-vpc"
#' target="_blank">Creating a VPC</a> in *VPC Endpoints for Amazon
#' Elasticsearch Service Domains*
#' @param CognitoOptions Options to specify the Cognito user and identity pools for Kibana
#' authentication. For more information, see <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html"
#' target="_blank">Amazon Cognito Authentication for Kibana</a>.
#' @param AdvancedOptions Modifies the advanced option to allow references to indices in an HTTP
#' request body. Must be `false` when configuring access to individual
#' sub-resources. By default, the value is `true`. See <a
#' href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html#es-createdomain-configure-advanced-options"
#' target="_blank">Configuration Advanced Options</a> for more information.
#' @param AccessPolicies IAM access policy as a JSON-formatted string.
#' @param LogPublishingOptions Map of `LogType` and `LogPublishingOption`, each containing options to
#' publish a given type of Elasticsearch log.
#' @param DomainEndpointOptions Options to specify configuration that will be applied to the domain
#' endpoint.
#' @param AdvancedSecurityOptions Specifies advanced security options.
#' @param NodeToNodeEncryptionOptions Specifies the NodeToNodeEncryptionOptions.
#' @param EncryptionAtRestOptions Specifies the Encryption At Rest Options.
#' @param AutoTuneOptions Specifies Auto-Tune options.
#' @param DryRun This flag, when set to True, specifies whether the
#' `UpdateElasticsearchDomain` request should return the results of
#' validation checks without actually applying the change. This flag, when
#' set to True, specifies the deployment mechanism through which the update
#' shall be applied on the domain. This will not actually perform the
#' Update.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_update_elasticsearch_domain_config
elasticsearchservice_update_elasticsearch_domain_config <- function(DomainName, ElasticsearchClusterConfig = NULL, EBSOptions = NULL, SnapshotOptions = NULL, VPCOptions = NULL, CognitoOptions = NULL, AdvancedOptions = NULL, AccessPolicies = NULL, LogPublishingOptions = NULL, DomainEndpointOptions = NULL, AdvancedSecurityOptions = NULL, NodeToNodeEncryptionOptions = NULL, EncryptionAtRestOptions = NULL, AutoTuneOptions = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "UpdateElasticsearchDomainConfig",
    http_method = "POST",
    http_path = "/2015-01-01/es/domain/{DomainName}/config",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$update_elasticsearch_domain_config_input(DomainName = DomainName, ElasticsearchClusterConfig = ElasticsearchClusterConfig, EBSOptions = EBSOptions, SnapshotOptions = SnapshotOptions, VPCOptions = VPCOptions, CognitoOptions = CognitoOptions, AdvancedOptions = AdvancedOptions, AccessPolicies = AccessPolicies, LogPublishingOptions = LogPublishingOptions, DomainEndpointOptions = DomainEndpointOptions, AdvancedSecurityOptions = AdvancedSecurityOptions, NodeToNodeEncryptionOptions = NodeToNodeEncryptionOptions, EncryptionAtRestOptions = EncryptionAtRestOptions, AutoTuneOptions = AutoTuneOptions, DryRun = DryRun)
  output <- .elasticsearchservice$update_elasticsearch_domain_config_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$update_elasticsearch_domain_config <- elasticsearchservice_update_elasticsearch_domain_config

#' Updates a package for use with Amazon ES domains
#'
#' @description
#' Updates a package for use with Amazon ES domains.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_update_package/](https://www.paws-r-sdk.com/docs/elasticsearchservice_update_package/) for full documentation.
#'
#' @param PackageID &#91;required&#93; Unique identifier for the package.
#' @param PackageSource &#91;required&#93; 
#' @param PackageDescription New description of the package.
#' @param CommitMessage An info message for the new version which will be shown as part of
#' `GetPackageVersionHistoryResponse`.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_update_package
elasticsearchservice_update_package <- function(PackageID, PackageSource, PackageDescription = NULL, CommitMessage = NULL) {
  op <- new_operation(
    name = "UpdatePackage",
    http_method = "POST",
    http_path = "/2015-01-01/packages/update",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$update_package_input(PackageID = PackageID, PackageSource = PackageSource, PackageDescription = PackageDescription, CommitMessage = CommitMessage)
  output <- .elasticsearchservice$update_package_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$update_package <- elasticsearchservice_update_package

#' Modifies an Amazon OpenSearch Service-managed interface VPC endpoint
#'
#' @description
#' Modifies an Amazon OpenSearch Service-managed interface VPC endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_update_vpc_endpoint/](https://www.paws-r-sdk.com/docs/elasticsearchservice_update_vpc_endpoint/) for full documentation.
#'
#' @param VpcEndpointId &#91;required&#93; Unique identifier of the VPC endpoint to be updated.
#' @param VpcOptions &#91;required&#93; The security groups and/or subnets to add, remove, or modify.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_update_vpc_endpoint
elasticsearchservice_update_vpc_endpoint <- function(VpcEndpointId, VpcOptions) {
  op <- new_operation(
    name = "UpdateVpcEndpoint",
    http_method = "POST",
    http_path = "/2015-01-01/es/vpcEndpoints/update",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$update_vpc_endpoint_input(VpcEndpointId = VpcEndpointId, VpcOptions = VpcOptions)
  output <- .elasticsearchservice$update_vpc_endpoint_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$update_vpc_endpoint <- elasticsearchservice_update_vpc_endpoint

#' Allows you to either upgrade your domain or perform an Upgrade
#' eligibility check to a compatible Elasticsearch version
#'
#' @description
#' Allows you to either upgrade your domain or perform an Upgrade eligibility check to a compatible Elasticsearch version.
#'
#' See [https://www.paws-r-sdk.com/docs/elasticsearchservice_upgrade_elasticsearch_domain/](https://www.paws-r-sdk.com/docs/elasticsearchservice_upgrade_elasticsearch_domain/) for full documentation.
#'
#' @param DomainName &#91;required&#93; 
#' @param TargetVersion &#91;required&#93; The version of Elasticsearch that you intend to upgrade the domain to.
#' @param PerformCheckOnly This flag, when set to True, indicates that an Upgrade Eligibility Check
#' needs to be performed. This will not actually perform the Upgrade.
#'
#' @keywords internal
#'
#' @rdname elasticsearchservice_upgrade_elasticsearch_domain
elasticsearchservice_upgrade_elasticsearch_domain <- function(DomainName, TargetVersion, PerformCheckOnly = NULL) {
  op <- new_operation(
    name = "UpgradeElasticsearchDomain",
    http_method = "POST",
    http_path = "/2015-01-01/es/upgradeDomain",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .elasticsearchservice$upgrade_elasticsearch_domain_input(DomainName = DomainName, TargetVersion = TargetVersion, PerformCheckOnly = PerformCheckOnly)
  output <- .elasticsearchservice$upgrade_elasticsearch_domain_output()
  config <- get_config()
  svc <- .elasticsearchservice$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticsearchservice$operations$upgrade_elasticsearch_domain <- elasticsearchservice_upgrade_elasticsearch_domain
