% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_update_destination}
\alias{firehose_update_destination}
\title{Updates the specified destination of the specified delivery stream}
\usage{
firehose_update_destination(
  DeliveryStreamName,
  CurrentDeliveryStreamVersionId,
  DestinationId,
  S3DestinationUpdate = NULL,
  ExtendedS3DestinationUpdate = NULL,
  RedshiftDestinationUpdate = NULL,
  ElasticsearchDestinationUpdate = NULL,
  AmazonopensearchserviceDestinationUpdate = NULL,
  SplunkDestinationUpdate = NULL,
  HttpEndpointDestinationUpdate = NULL,
  AmazonOpenSearchServerlessDestinationUpdate = NULL,
  SnowflakeDestinationUpdate = NULL,
  IcebergDestinationUpdate = NULL
)
}
\arguments{
\item{DeliveryStreamName}{[required] The name of the delivery stream.}

\item{CurrentDeliveryStreamVersionId}{[required] Obtain this value from the \code{VersionId} result of
DeliveryStreamDescription. This value is required, and helps the service
perform conditional operations. For example, if there is an interleaving
update and this value is null, then the update destination fails. After
the update is successful, the \code{VersionId} value is updated. The service
then performs a merge of the old configuration with the new
configuration.}

\item{DestinationId}{[required] The ID of the destination.}

\item{S3DestinationUpdate}{[Deprecated] Describes an update for a destination in Amazon S3.}

\item{ExtendedS3DestinationUpdate}{Describes an update for a destination in Amazon S3.}

\item{RedshiftDestinationUpdate}{Describes an update for a destination in Amazon Redshift.}

\item{ElasticsearchDestinationUpdate}{Describes an update for a destination in Amazon ES.}

\item{AmazonopensearchserviceDestinationUpdate}{Describes an update for a destination in Amazon OpenSearch Service.}

\item{SplunkDestinationUpdate}{Describes an update for a destination in Splunk.}

\item{HttpEndpointDestinationUpdate}{Describes an update to the specified HTTP endpoint destination.}

\item{AmazonOpenSearchServerlessDestinationUpdate}{Describes an update for a destination in the Serverless offering for
Amazon OpenSearch Service.}

\item{SnowflakeDestinationUpdate}{Update to the Snowflake destination configuration settings.}

\item{IcebergDestinationUpdate}{Describes an update for a destination in Apache Iceberg Tables.

Amazon Data Firehose is in preview release and is subject to change.}
}
\description{
Updates the specified destination of the specified delivery stream.

See \url{https://www.paws-r-sdk.com/docs/firehose_update_destination/} for full documentation.
}
\keyword{internal}
