% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firehose_operations.R
\name{firehose_list_delivery_streams}
\alias{firehose_list_delivery_streams}
\title{Lists your delivery streams in alphabetical order of their names}
\usage{
firehose_list_delivery_streams(
  Limit = NULL,
  DeliveryStreamType = NULL,
  ExclusiveStartDeliveryStreamName = NULL
)
}
\arguments{
\item{Limit}{The maximum number of delivery streams to list. The default value is 10.}

\item{DeliveryStreamType}{The delivery stream type. This can be one of the following values:
\itemize{
\item \code{DirectPut}: Provider applications access the delivery stream
directly.
\item \code{KinesisStreamAsSource}: The delivery stream uses a Kinesis data
stream as a source.
}

This parameter is optional. If this parameter is omitted, delivery
streams of all types are returned.}

\item{ExclusiveStartDeliveryStreamName}{The list of delivery streams returned by this call to
\code{\link[=firehose_list_delivery_streams]{list_delivery_streams}} will start
with the delivery stream whose name comes alphabetically immediately
after the name you specify in \code{ExclusiveStartDeliveryStreamName}.}
}
\description{
Lists your delivery streams in alphabetical order of their names.

See \url{https://www.paws-r-sdk.com/docs/firehose_list_delivery_streams/} for full documentation.
}
\keyword{internal}
