% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_update_shard_count}
\alias{kinesis_update_shard_count}
\title{Updates the shard count of the specified stream to the specified number
of shards}
\usage{
kinesis_update_shard_count(StreamName, TargetShardCount, ScalingType)
}
\arguments{
\item{StreamName}{[required] The name of the stream.}

\item{TargetShardCount}{[required] The new number of shards. This value has the following default limits.
By default, you cannot do the following:
\itemize{
\item Set this value to more than double your current shard count for a
stream.
\item Set this value below half your current shard count for a stream.
\item Set this value to more than 10000 shards in a stream (the default
limit for shard count per stream is 10000 per account per region),
unless you request a limit increase.
\item Scale a stream with more than 10000 shards down unless you set this
value to less than 10000 shards.
}}

\item{ScalingType}{[required] The scaling type. Uniform scaling creates shards of equal size.}
}
\description{
Updates the shard count of the specified stream to the specified number of shards.

See \url{https://paws-r.github.io/docs/kinesis/update_shard_count.html} for full documentation.
}
\keyword{internal}
