% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kafka_operations.R
\name{kafka_create_configuration}
\alias{kafka_create_configuration}
\title{Creates a new MSK configuration}
\usage{
kafka_create_configuration(Description, KafkaVersions, Name,
  ServerProperties)
}
\arguments{
\item{Description}{<p>The description of the configuration.</p>}

\item{KafkaVersions}{<p>The versions of Apache Kafka with which you can use this MSK configuration.</p>}

\item{Name}{[required]
<p>The name of the configuration.</p>}

\item{ServerProperties}{[required]
<p>Contents of the <filename>server.properties</filename> file. When using the API, you must ensure that the contents of the file are base64 encoded.
When using the AWS Management Console, the SDK, or the AWS CLI, the contents of <filename>server.properties</filename> can be in plaintext.</p>}
}
\description{
\preformatted{        <p>Creates a new MSK configuration.</p>
}
}
\section{Request syntax}{
\preformatted{svc$create_configuration(
  Description = "string",
  KafkaVersions = list(
    "string"
  ),
  Name = "string",
  ServerProperties = raw
)
}
}

\keyword{internal}
