% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_connection}
\alias{glue_get_connection}
\title{Retrieves a connection definition from the Data Catalog}
\usage{
glue_get_connection(CatalogId, Name, HidePassword)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog in which the connection resides. If none is
provided, the AWS account ID is used by default.}

\item{Name}{[required] The name of the connection definition to retrieve.}

\item{HidePassword}{Allows you to retrieve the connection metadata without returning the
password. For instance, the AWS Glue console uses this flag to retrieve
the connection, and does not display the password. Set this parameter
when the caller might not have permission to use the AWS KMS key to
decrypt the password, but it does have permission to access the rest of
the connection properties.}
}
\description{
Retrieves a connection definition from the Data Catalog.
}
\section{Request syntax}{
\preformatted{svc$get_connection(
  CatalogId = "string",
  Name = "string",
  HidePassword = TRUE|FALSE
)
}
}

\keyword{internal}
