% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_batch_delete_table}
\alias{glue_batch_delete_table}
\title{Deletes multiple tables at once}
\usage{
glue_batch_delete_table(CatalogId, DatabaseName, TablesToDelete)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the table resides. If none is supplied,
the AWS account ID is used by default.}

\item{DatabaseName}{[required] The name of the catalog database where the tables to delete reside. For
Hive compatibility, this name is entirely lowercase.}

\item{TablesToDelete}{[required] A list of the table to delete.}
}
\description{
Deletes multiple tables at once.
}
\details{
After completing this operation, you will no longer have access to the
table versions and partitions that belong to the deleted table. AWS Glue
deletes these "orphaned" resources asynchronously in a timely manner,
at the discretion of the service.

To ensure immediate deletion of all related resources, before calling
\code{BatchDeleteTable}, use \code{DeleteTableVersion} or
\code{BatchDeleteTableVersion}, and \code{DeletePartition} or
\code{BatchDeletePartition}, to delete any resources that belong to the
table.
}
\section{Request syntax}{
\preformatted{svc$batch_delete_table(
  CatalogId = "string",
  DatabaseName = "string",
  TablesToDelete = list(
    "string"
  )
)
}
}

\keyword{internal}
