% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearchdomain_service.R
\name{cloudsearchdomain}
\alias{cloudsearchdomain}
\title{Amazon CloudSearch Domain}
\usage{
cloudsearchdomain(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
You use the AmazonCloudSearch2013 API to upload documents to a search
domain and search those documents.

The endpoints for submitting
\code{\link[=cloudsearchdomain_upload_documents]{upload_documents}},
\code{\link[=cloudsearchdomain_search]{search}}, and
\code{\link[=cloudsearchdomain_suggest]{suggest}} requests are domain-specific. To
get the endpoints for your domain, use the Amazon CloudSearch
configuration service \code{DescribeDomains} action. The domain endpoints are
also displayed on the domain dashboard in the Amazon CloudSearch
console. You submit suggest requests to the search endpoint.

For more information, see the \href{https://docs.aws.amazon.com/cloudsearch/latest/developerguide/}{Amazon CloudSearch Developer Guide}.
}
\section{Service syntax}{
\preformatted{svc <- cloudsearchdomain(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=cloudsearchdomain_search]{search} \tab Retrieves a list of documents that match the specified search criteria\cr
\link[=cloudsearchdomain_suggest]{suggest} \tab Retrieves autocomplete suggestions for a partial query string\cr
\link[=cloudsearchdomain_upload_documents]{upload_documents} \tab Posts a batch of documents to a search domain for indexing
}
}

\examples{
\dontrun{
svc <- cloudsearchdomain()
svc$search(
  Foo = 123
)
}

}
