% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_start_job_run}
\alias{glue_start_job_run}
\title{Starts a job run using a job definition}
\usage{
glue_start_job_run(JobName, JobRunId, Arguments, AllocatedCapacity,
  Timeout, MaxCapacity, NotificationProperty, SecurityConfiguration)
}
\arguments{
\item{JobName}{[required] The name of the job definition to use.}

\item{JobRunId}{The ID of a previous JobRun to retry.}

\item{Arguments}{The job arguments specifically for this run. For this job run, they
replace the default arguments set in the job definition itself.

You can specify arguments here that your own job-execution script
consumes, as well as arguments that AWS Glue itself consumes.

For information about how to specify and consume your own Job arguments,
see the \href{http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-python-calling.html}{Calling AWS Glue APIs in Python}
topic in the developer guide.

For information about the key-value pairs that AWS Glue consumes to set
up your job, see the \href{http://docs.aws.amazon.com/glue/latest/dg/aws-glue-programming-etl-glue-arguments.html}{Special Parameters Used by AWS Glue}
topic in the developer guide.}

\item{AllocatedCapacity}{This field is deprecated, use \code{MaxCapacity} instead.

The number of AWS Glue data processing units (DPUs) to allocate to this
JobRun. From 2 to 100 DPUs can be allocated; the default is 10. A DPU is
a relative measure of processing power that consists of 4 vCPUs of
compute capacity and 16 GB of memory. For more information, see the \href{https://aws.amazon.com/glue/pricing/}{AWS Glue pricing page}.}

\item{Timeout}{The JobRun timeout in minutes. This is the maximum time that a job run
can consume resources before it is terminated and enters \code{TIMEOUT}
status. The default is 2,880 minutes (48 hours). This overrides the
timeout value set in the parent job.}

\item{MaxCapacity}{The number of AWS Glue data processing units (DPUs) that can be
allocated when this job runs. A DPU is a relative measure of processing
power that consists of 4 vCPUs of compute capacity and 16 GB of memory.
For more information, see the \href{https://aws.amazon.com/glue/pricing/}{AWS Glue pricing page}.

The value that can be allocated for \code{MaxCapacity} depends on whether you
are running a python shell job, or an Apache Spark ETL job:
\itemize{
\item When you specify a python shell job
(\code{JobCommand.Name}="pythonshell"), you can allocate either 0.0625
or 1 DPU. The default is 0.0625 DPU.
\item When you specify an Apache Spark ETL job
(\code{JobCommand.Name}="glueetl"), you can allocate from 2 to 100
DPUs. The default is 10 DPUs. This job type cannot have a fractional
DPU allocation.
}}

\item{NotificationProperty}{Specifies configuration properties of a job run notification.}

\item{SecurityConfiguration}{The name of the SecurityConfiguration structure to be used with this job
run.}
}
\description{
Starts a job run using a job definition.
}
\section{Request syntax}{
\preformatted{svc$start_job_run(
  JobName = "string",
  JobRunId = "string",
  Arguments = list(
    "string"
  ),
  AllocatedCapacity = 123,
  Timeout = 123,
  MaxCapacity = 123.0,
  NotificationProperty = list(
    NotifyDelayAfter = 123
  ),
  SecurityConfiguration = "string"
)
}
}

\keyword{internal}
