% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_trigger}
\alias{glue_create_trigger}
\title{Creates a new trigger}
\usage{
glue_create_trigger(Name, Type, Schedule, Predicate, Actions,
  Description, StartOnCreation, Tags)
}
\arguments{
\item{Name}{[required] The name of the trigger.}

\item{Type}{[required] The type of the new trigger.}

\item{Schedule}{A \code{cron} expression used to specify the schedule (see \href{http://docs.aws.amazon.com/glue/latest/dg/monitor-data-warehouse-schedule.html}{Time-Based Schedules for Jobs and Crawlers}.
For example, to run something every day at 12:15 UTC, you would specify:
\code{cron(15 12 * * ? *)}.

This field is required when the trigger type is SCHEDULED.}

\item{Predicate}{A predicate to specify when the new trigger should fire.

This field is required when the trigger type is CONDITIONAL.}

\item{Actions}{[required] The actions initiated by this trigger when it fires.}

\item{Description}{A description of the new trigger.}

\item{StartOnCreation}{Set to true to start SCHEDULED and CONDITIONAL triggers when created.
True not supported for ON\_DEMAND triggers.}

\item{Tags}{The tags to use with this trigger. You may use tags to limit access to
the trigger. For more information about tags in AWS Glue, see \href{http://docs.aws.amazon.com/glue/latest/dg/monitor-tags.html}{AWS Tags in AWS Glue} in
the developer guide.}
}
\description{
Creates a new trigger.
}
\section{Request syntax}{
\preformatted{svc$create_trigger(
  Name = "string",
  Type = "SCHEDULED"|"CONDITIONAL"|"ON_DEMAND",
  Schedule = "string",
  Predicate = list(
    Logical = "AND"|"ANY",
    Conditions = list(
      list(
        LogicalOperator = "EQUALS",
        JobName = "string",
        State = "STARTING"|"RUNNING"|"STOPPING"|"STOPPED"|"SUCCEEDED"|"FAILED"|"TIMEOUT"
      )
    )
  ),
  Actions = list(
    list(
      JobName = "string",
      Arguments = list(
        "string"
      ),
      Timeout = 123,
      NotificationProperty = list(
        NotifyDelayAfter = 123
      ),
      SecurityConfiguration = "string"
    )
  ),
  Description = "string",
  StartOnCreation = TRUE|FALSE,
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
