% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudsearch_operations.R
\name{cloudsearch_update_availability_options}
\alias{cloudsearch_update_availability_options}
\title{Configures the availability options for a domain}
\usage{
cloudsearch_update_availability_options(DomainName, MultiAZ)
}
\arguments{
\item{DomainName}{[required]}

\item{MultiAZ}{[required] You expand an existing search domain to a second Availability Zone by
setting the Multi-AZ option to true. Similarly, you can turn off the
Multi-AZ option to downgrade the domain to a single Availability Zone by
setting the Multi-AZ option to \code{false}.}
}
\description{
Configures the availability options for a domain. Enabling the Multi-AZ
option expands an Amazon CloudSearch domain to an additional
Availability Zone in the same Region to increase fault tolerance in the
event of a service disruption. Changes to the Multi-AZ option can take
about half an hour to become active. For more information, see
\href{http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-availability-options.html}{Configuring Availability Options}
in the \emph{Amazon CloudSearch Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_availability_options(
  DomainName = "string",
  MultiAZ = TRUE|FALSE
)
}
}

\keyword{internal}
