% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procimg.R
\name{procimg}
\alias{procimg}
\title{Process images}
\usage{
procimg(image, resize = NULL, rotate = NULL, scaledist = NULL,
  outline = FALSE, reclass = NULL, smooth = FALSE, iterations = 1L,
  col = "red", plotnew = FALSE, ...)
}
\arguments{
\item{image}{(required) image data. Either a single image array, or a number of images
stored in a list. Preferably the result of \code{\link[=getimg]{getimg()}}.}

\item{resize}{an integer specifying a percentage for resizing images, if so desired.
E.g. 50 to half the size of an image, 200 to double it.}

\item{rotate}{an integer specifying the angle of image rotation, in degrees. Images
are rotated around the centre, and linearly interpolated.}

\item{scaledist}{an integer, or numeric vector equal in length to the number of images,
specifying the length of the scale in the image(s). Image(s) will then be presented,
and the user asked to select either end of the scale corresponding to the input value.}

\item{outline}{interactively specify the focal object in
an image by clicking around its outline. The xy-coordinates of the resulting
closed polygon are saved as an attribute, for use in generating a masking layer &
separating animals/plants from backgrounds in further analyses. This is particularly
useful when backgrounds are complex, such as in natural settings.}

\item{reclass}{interactively specify an area on a colour-classified image that is
to be reclassified as the numeric value provided. e.g. when \code{reclass = 1}, the user
will be asked to select a polygon on the image, within which all colour-category values will be
changes to \code{1}.}

\item{smooth}{should the polygon specified when \code{outline = TRUE} be smoothed
using Chaikin's corner-cuting algorithm? Defaults to \code{FALSE}.}

\item{iterations}{the number of smoothing iterations, when \code{smooth = TRUE}.
Defaults to \code{1}.}

\item{col}{the color of the marker points and/or line, when using interactive options.}

\item{plotnew}{should plots be opened in a new window? Defaults to \code{FALSE}.}

\item{...}{additional graphical parameters. Also see \code{\link[=par]{par()}}.}
}
\value{
an image, or list of images, for use in further
\code{pavo} functions.
}
\description{
Specify scales, resize, and/or define focal objects within images.
}
\examples{
\dontrun{
# Single image
papilio <- getimg(system.file("testdata/images/papilio.png", package = "pavo"))
papilio <- procimg(papilio, scaledist = 10)

# Assign individual scales to each image, after slightly reducing their size.
snakes <- getimg(system.file("testdata/images/snakes", package = "pavo"))
snakes <- procimg(snakes, scaledist = c(10, 14), resize = 90)
}

}
\references{
Chaikin, G. 1974. An algorithm for high speed curve generation.
Computer Graphics and Image Processing 3, 346-349.
}
\author{
Thomas E. White \email{thomas.white026@gmail.com}
}
