% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsmooth.R
\name{plotsmooth}
\alias{plotsmooth}
\title{Plot loess smoothed curves}
\usage{
plotsmooth(rspecdata, minsmooth = 0.05, maxsmooth = 0.2, curves = 5,
  specnum = 0, ask = TRUE)
}
\arguments{
\item{rspecdata}{(required) a data frame, possibly of class \code{rspec}, which
contains a column containing a wavelength range, named 'wl', and spectra data in
remaining columns.}

\item{minsmooth}{the minimum f value of the loess function to visualize (defaults to \code{0.05}).}

\item{maxsmooth}{the maximum f value of the loess function to visualize (defaults to \code{0.20}).}

\item{curves}{the number of curves to display on the same plot (defaults to \code{5}).}

\item{specnum}{the number of spectral curves, from the data frame, to visualize (defaults to \code{ALL}).}

\item{ask}{logical. if \code{TRUE}, asks for user input before changing plot pages}
}
\value{
Series of plot with curves processed with varying level of loess smoothing
}
\description{
Plots spectral curves with various levels of loess smoothing to help decide which
loess parameters are best for subsequently smoothing the data (e.g. via \code{\link[=procspec]{procspec()}}).
}
\examples{
data(sicalis)
plotsmooth(sicalis, minsmooth = 0.05, maxsmooth = 0.1, curves = 7, specnum = 6)
}
\seealso{
\code{\link[=procspec]{procspec()}}
}
\author{
Pierre-Paul Bitton \email{bittonp@uwindsor.ca}
}
