% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec2rgb.R
\name{spec2rgb}
\alias{spec2rgb}
\title{Spectrum to rgb colour conversion}
\usage{
spec2rgb(rspecdata, alpha = 1)
}
\arguments{
\item{rspecdata}{(required) a data frame, possibly an object of class \code{rspec}
that has wavelength range in the first column, named 'wl', and spectral measurements in the
remaining columns.}

\item{alpha}{alpha value to use for colors (defaults to 1, opaque).}
}
\value{
A character vector consisting of hexadecimal colour values
for passing to further plotting functions.
}
\description{
Calculates rgb values from spectra based on human colour matching functions.
}
\examples{
data(teal)
spec2rgb(teal)

# Plot data using estimated perceived colour
plot(teal, col = spec2rgb(teal), type = "o")
}
\references{
CIE(1932). Commission Internationale de l'Eclairage Proceedings, 1931. Cambridge: Cambridge University Press.
}
\author{
Hugo Gruson \email{hugo.gruson+R@normalesup.org}

Chad Eliason \email{cme16@zips.uakron.edu}
}
