% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jndrot.R
\name{jndrot}
\alias{jndrot}
\title{Rotate Cartesian coordinates obtained from \code{jnd2xyz}}
\usage{
jndrot(jnd2xyzres, center = c("mean", "achro"), ref1 = "l",
  ref2 = "u", axis1 = c(1, 1, 0), axis2 = c(0, 0, 1))
}
\arguments{
\item{jnd2xyzres}{(required) the output from a \code{jnd2xyz} call.}

\item{center}{should the vectors for rotation be centered in the achromatic
center ("achro") or the data centroid ("mean", the default)?}

\item{ref1}{the cone to be used as a the first reference. May be NULL
(for no first rotation in the 3-dimensional case) or must match name
in the original data that was used for \code{coldist}. Defaults to 'l'.}

\item{ref2}{the cone to be used as a the second reference.May be NULL
(for no first rotation in the 3-dimensional case) or must match name
in the original data that was used for \code{coldist}. Defaults to 'u'.
(only used if data has 3 dimensions).}

\item{axis1}{A vector of length 3 composed of 0's and 1's, with
1's representing the axes (x,y,z) to rotate around. Defaults to c(1,1,0), such
that the rotation aligns with the xy plane (only used if data has 2 or 3 dimensions).
Ignored if \code{ref1} is NULL (in 3-dimensional case only)}

\item{axis2}{A vector of length 3 composed of 0's and 1's, with
1's representing the axes (x,y,z) to rotate around. Defaults to c(0,0,1), such
that the rotation aligns with the z axis (only used if data has 3 dimensions).
Ignored if \code{ref2} is NULL (in 3-dimensional case only)}
}
\description{
Rotates the Cartesian coordinates obtained from \code{jnd2xyz}
}
\examples{
data(flowers)
vis.flowers <- vismodel(flowers)
cd.flowers <- coldist(vis.flowers)
jndrot(jnd2xyz(cd.flowers))
}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}
}
\keyword{internal}
