% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/catplot.R
\name{catplot}
\alias{catplot}
\title{Plot the categorical colour vision model}
\usage{
catplot(catdata, labels = TRUE, lab.cex = 0.9, ...)
}
\arguments{
\item{catdata}{(required) a data frame, possibly a result from the \code{categorical} 
function, containing values for 'x' and 'y' coordinates as columns (labeled as such).}

\item{labels}{plot category labels inside? Defaults to \code{TRUE}.}

\item{lab.cex}{character expansion factor for category labels when \code{labels = TRUE}).}

\item{...}{additional graphical options. See \code{\link{par}}.}
}
\description{
Produces a plot based on Troje's (1993) categorical colour model.
}
\examples{
\dontrun{
data(flowers)
vis.flowers <- vismodel(flowers, qcatch = 'Qi', visual = 'musca', achro = 'none', relative = TRUE)
cat.flowers <- colspace(vis.flowers, space = 'categorical')
plot(cat.flowers)
}

}
\references{
Troje N. (1993). Spectral categories in the learning behaviour
 of blowflies. Zeitschrift fur Naturforschung C, 48, 96-96.
}
\author{
Thomas White \email{thomas.white026@gmail.com}
}
\keyword{internal}
