% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{formatParamVarTextPlot}
\alias{formatParamVarTextPlot}
\title{Format text variables for the subject profile text plotting function.}
\usage{
formatParamVarTextPlot(
  data,
  paramVar = NULL,
  paramValueVar = NULL,
  paramValueLab = NULL,
  paramGroupVar = NULL,
  revert = FALSE,
  width = formatReport$yLabelWidth,
  widthValue = ifelse(formatReport$landscape, 240, 190),
  formatReport = subjectProfileReportFormat(),
  table = FALSE,
  colWidth = NULL
)
}
\arguments{
\item{data}{data.frame with data}

\item{paramVar}{string, variable of \code{data} with parameter}

\item{paramValueVar}{string, variable of \code{data} containing the parameter value.}

\item{paramValueLab}{Character vector with labels for \code{paramValueVar}.}

\item{paramGroupVar}{(optional) character vector with variable(s) of \code{data} with grouping.
If specified, the parameters will be grouped by this(these) variable(s) in the y-axis.}

\item{revert}{logical, if TRUE revert the order of the levels of the variable}

\item{width}{max number of characters in the code{paramVar} parameter.}

\item{widthValue}{max number of characters in the code{paramValueVar} parameter.}

\item{formatReport}{list with parameters used to specify the format of the report,
e.g. output of the \code{\link{subjectProfileReportFormat}} function}

\item{table}{Logical, if TRUE the \code{paramValueVar} variables
are displayed as table (so are not concatenated).}

\item{colWidth}{Numeric vector with approximate
width of each parameter value column
for a table layout.\cr
For example in case two parameters are specified: 
\code{c(0.8, 0.2))} such as the first column
takes 80\% of plot area, and the second column 20\%.\cr
Note: columns can be slightly bigger if their content is 
larger than the specified width.
If not specified, column width is optimized
based on the max length of the character in each column.}
}
\value{
\code{data} with reformatted \code{paramVar} and \code{paramValueVar} variables,
with additional attribute: \code{colWidth}.
}
\description{
Text variables are wrapped across multiple lines if needed,
and optionally sorted according to the levels
of a grouping variable.
}
\seealso{
\link{subjectProfileTextPlot}
}
\author{
Laure Cougnaud
}
