% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{get_full_trajectories}
\alias{get_full_trajectories}
\title{Retain trajectories that span a selected region of interest}
\usage{
get_full_trajectories(obj_name, span = 0.8, ...)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{span}{Span to use; must be numeric and between 0 and 1}

\item{...}{Additional arguments passed to/from other pathviewr functions}
}
\value{
A viewr object (tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}) in which only
trajectories that span the region of interest are retained. Data are
labeled by direction  (either "leftwards" or "rightwards") with respect to
their starting and ending \code{position_length} values in the
\code{direction} column.
}
\description{
Specify a minimum span of the selected region of interest and then keep
trajectories that are wider than that span and go from one end to the other
of the region.
}
\details{
Because trajectories may not have observations exactly at the
beginning or the end of the region of interest, it may be necessary to allow
trajectories to be slightly shorter than the range of the selected region of
interest. The \code{span} parameter of this function handles this. By
supplying a numeric proportion from 0 to 1, a user may allow trajectories to
span that proportion of the selected region. For example, setting \code{span
= 0.95} will keep all trajectories that span 95\% of the length of the
selected region of interest. Setting \code{span = 1} (not recommended) will
strictly keep trajectories that start and end at the exact cut-offs of the
selected region of interest. For these reasons, \code{span}s of 0.99 to 0.95
are generally recommended.
}
\examples{
motive_data <-
  read_motive_csv(system.file("extdata", "pathviewr_motive_example_data.csv",
                              package = 'pathviewr'))

## Clean the file. It is generally recommended to clean up to the
## "separate" step before running select_x_percent().
motive_separated <-
  motive_data \%>\%
  relabel_viewr_axes() \%>\%
  gather_tunnel_data() \%>\%
  trim_tunnel_outliers() \%>\%
  rotate_tunnel() \%>\%
  select_x_percent(desired_percent = 50) \%>\%
  separate_trajectories(max_frame_gap = "autodetect",
                        frame_rate_proportion = 0.1)

## Now retain only the "full" trajectories that span
## across 0.95 of the range of position_length
motive_full <-
  motive_separated \%>\%
  get_full_trajectories(span = 0.95)
}
\seealso{
Other data cleaning functions: 
\code{\link{gather_tunnel_data}()},
\code{\link{quick_separate_trajectories}()},
\code{\link{redefine_tunnel_center}()},
\code{\link{relabel_viewr_axes}()},
\code{\link{rename_viewr_characters}()},
\code{\link{rotate_tunnel}()},
\code{\link{select_x_percent}()},
\code{\link{separate_trajectories}()},
\code{\link{standardize_tunnel}()},
\code{\link{trim_tunnel_outliers}()},
\code{\link{visualize_frame_gap_choice}()}

Other functions that define or clean trajectories: 
\code{\link{quick_separate_trajectories}()},
\code{\link{separate_trajectories}()},
\code{\link{visualize_frame_gap_choice}()}
}
\author{
Vikram B. Baliga
}
\concept{data cleaning functions}
\concept{functions that define or clean trajectories}
