% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/paths.R
\name{create_dirs}
\alias{create_dirs}
\alias{remove_dirs}
\title{Create or remove directories}
\usage{
create_dirs(x = temp_file(pattern = "dir"))

remove_dirs(x)
}
\arguments{
\item{x}{A character vector of paths of directories to create/remove.
For \code{create_dirs}, it defaults to a directory inside \code{tempdir()}.}
}
\value{
A logical vector of successes of failures.
}
\description{
A vectorized version of \code{\link[base]{dir.create}}, and
\code{\link[base]{unlink}} with more convenient defaults.
}
\note{
\code{\link[base]{unlink}}, and consequently \code{remove_dirs},
sometimes fails to remove empty directories.
See \url{https://bugs.r-project.org/bugzilla3/show_bug.cgi?id=16287}.
}
\examples{
\donttest{
dirs <- file.path(temp_dir(), c("foo", "bar/baz"))
create_dirs(dirs)

# Check this worked:
assert_all_are_dirs(dirs)

# Clean up
remove_dirs(dirs)
}
}
\seealso{
\code{\link[base]{dir.create}}, \code{\link[base]{unlink}}
}

